local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local CreateConditionCommand = CommandBase:extend("CreateConditionCommand");

function CreateConditionCommand:new(comuid, smsId, tranid)
    CreateConditionCommand.super.new(self);
    self._comUid = comuid;
    self._UUID = ContentManager:GenerateUUID();
    self._tranId = tranid;
    self._smsId = smsId;
end

function CreateConditionCommand:DoIt()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
        local trans = ani:GetTransitionById(self._smsId, self._tranId);
        if trans then
            local con = apolloengine.Condition();
            con:SetStaticID(self._UUID);
            self._transition:AddCondition(con);
        end   
    end
    self:EndCmd();
end

function CreateConditionCommand:Undo()
    self:BeginCmd();
    local ani = self:GetContent(self._comUid);
    if ani then
        local trans = ani:GetTransitionById(self._smsId, self._tranId);
        if trans then
            trans:RemoveConditionById(self._UUID);
        end   
    end
    self:EndCmd();
end

return CreateConditionCommand;