local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local filelfs = require "window.editor.widget.assets.fileutility"
local CommandBase = require "window.editor.command.command"
local ContentManager = require "apolloengine.content.contentmanager"
local ChangeStateNameCommand = CommandBase:extend("ChangeStateNameCommand");

function ChangeStateNameCommand:new(uuid, stateId,name)
    ChangeStateNameCommand.super.new(self);
    self._uuid = uuid;
    self._stateId = stateId;
    self._name =  name;
    self._prevname = nil;
    self._state = nil;
end

function ChangeStateNameCommand:DoIt()
    self:BeginCmd();
    if self._uuid then
      local ani = self:GetContent(self._uuid); --基类中方法：可以根据id返回对象
      if ani then
       local state = ani:GetStateById(0, self._stateId);
       if state then
         self._prevname = state.Name;
         state.Name = self._name;
       end
      
      end
    end
    self:EndCmd();
end

function ChangeStateNameCommand:Undo()
    self:BeginCmd();
    if self._state then
        self._state.Name = self._prevname;
    end
    self:EndCmd();
end

return ChangeStateNameCommand;