--Geman-McClure robustifier

local venusjson = require "venusjson"
local venuscore = require "venuscore"

local torch = require "torch"
local Operator = require "torchutility.operator"


local CameraVeiwProj = Operator:extend();


--[[
threro
    fx,0,cx        point3dx 
    0,fy,cy   *    point3dy
    0, 0, 1        point3dz
real
    x  y   z       fx,0, 0        
             *     0,fy, 0       
                   cx,cy,1        
]]

function CameraVeiwProj:new(fx,fy,cx,cy,...)
    self.intrinsicMat = torch.Tensor(3,3):zero();
    self.intrinsicMat[1][1] = fx;
    self.intrinsicMat[2][2] = fy;
    self.intrinsicMat[3][3] = 1;
    self.intrinsicMat[3][1] = cx;
    self.intrinsicMat[3][2] = cy;
    self.fx = fx;
    self.fy = fy;
    self.cx = cx;
    self.cy = cy;
    CameraVeiwProj.super.new(self,...);
   
end

function CameraVeiwProj:Caculate( param )
    return self:Proj(param);
end

function CameraVeiwProj:Derivative(param)
   
    if self:HasParamForD(1,param) then
        return self:DXYZ_Proj(param);
    else
        assert(false);
    end
end


function CameraVeiwProj:Proj(points3d)
    self.input3d = points3d;
    local ret = points3d*self.intrinsicMat;
    local ret2d = torch.Tensor(ret:size(1),2);

    for i=1,ret:size(1) do
        ret2d[i][1] = ret[i][1]/ret[i][3];
        ret2d[i][2] = ret[i][2]/ret[i][3];
    end
    return ret2d;
end  


function CameraVeiwProj:DXYZ_Proj(points3d)
    if points3d==nil then
        points3d = self.input3d;
    end
   
    local point3dCount = points3d:size(1);
    --LOG("points3d SIZE:"..point3dCount);
    local result = torch.Tensor(2*point3dCount,3*point3dCount);
    result:fill(0);

    local dxx = torch.Tensor(point3dCount);
    for i=1,point3dCount do
        dxx[i] = self:DXX(points3d[i][1],points3d[i][2],points3d[i][3]);
        result[1+2*(i-1)][1+3*(i-1)] = dxx[i];
    end
    
    local dyy = torch.Tensor(point3dCount);
    for i=1,point3dCount do
        dyy[i] = self:DYY(points3d[i][1],points3d[i][2],points3d[i][3]);
        result[2+2*(i-1)][2+3*(i-1)] = dyy[i];
    end
    --self:FillDiag(dyy,1+point3dCount,1,result);

    local dxz = torch.Tensor(point3dCount);
    for i=1,point3dCount do
        dxz[i] = self:DXZ(points3d[i][1],points3d[i][2],points3d[i][3]);
        result[1+2*(i-1)][3+3*(i-1)] = dxz[i];
    end
    --self:FillDiag(dxz,1,1+point3dCount*2,result);

    local dyz = torch.Tensor(point3dCount);
    for i=1,point3dCount do
        dyz[i] = self:DYZ(points3d[i][1],points3d[i][2],points3d[i][3]);
        result[2+2*(i-1)][3+3*(i-1)] = dyz[i];
    end
    --self:FillDiag(dyz,1+point3dCount,1+point3dCount*2,result);
    return result;
end  

function CameraVeiwProj:DXX(x,y,z)
    return self.fx/z;
end

function CameraVeiwProj:DYY(x,y,z)
    return self.fy/z;
end

function CameraVeiwProj:DXZ(x,y,z)
    return -1*self.fx*x/(z*z);
end

function CameraVeiwProj:DYZ(x,y,z)
    return -1*self.fy*y/(z*z);
end

function CameraVeiwProj:FillDiag(array,startx,starty,mat)
    local length = array:size()[1];
    for i = 0,length-1 do
        mat[startx+i][starty+i] = array[i+1];
    end
end

return CameraVeiwProj;

