--
-- blue functional library(global function)
--
local VC = require "libvenuscore"
local BlueFtnLib  = VC.Object:extend("BlueFtnLib");

BlueFtnLib:MemberRegister("_LibName");
BlueFtnLib:MemberRegister("_LibId");
BlueFtnLib:MemberRegister("_LibFtns");

function BlueFtnLib:new(name, uid, ...)
  BlueFtnLib.super.new(self, ...)
  self._LibName = name ;
  self._LibId = uid ;
  self._LibFtns = {};

  self.errorMessage = nil;
end

function BlueFtnLib:CreateByEd()

end

function BlueFtnLib:_OnDeserialize()
  -- BlueFtnLib.super._OnDeserialize(self); -- Lua Object do NOT have _OnDeserialize
  -- self._LibId recovery while deserialize
end

function BlueFtnLib:GetLibId()
  return self._LibId;
end

function BlueFtnLib:GetLibName()
  return self._LibName;
end

function BlueFtnLib:ChgLibName(libName)
  self._LibName = libName ;
  -- 目前函数库的名字没有被引用
end

function BlueFtnLib:TryNameEd(ftnName)
  for uid, func in pairs(self._LibFtns) do
    local _name = func:GetName()
    if _name == ftnName then
      return false ;
    end
  end
  return true ;
end

function BlueFtnLib:GetResourceDependencies()
  local result = {};
  for uid, func in pairs(self._LibFtns) do
    local dependencies = func:GetDependencies();
    for _, path in pairs(dependencies) do
      table.insert(result, path);
    end
  end
  return result;
end

function BlueFtnLib:IsConflictUidEd(ftnUid)
  return self._LibFtns[ftnUid] ~= nil
end

-- 本函数库销毁
function BlueFtnLib:DeleteLibEd()
  WARNING("DeleteLibEd begin");
  for uid, ftn in pairs(self._LibFtns) do
    ftn:ToBeDeletedEd();
  end
  WARNING("DeleteLibEd done");
end


function BlueFtnLib:AddFtnEd(uid, blueFunction)
  if self:IsConflictUidEd(uid) then ERROR("AddFtnEd Conflict"); return; end
  self._LibFtns[uid] = blueFunction
end


function BlueFtnLib:DelFtnEd(uid)

  -- 删除函数的通知 有函数自己处理
  local func = self._LibFtns[uid]
  if func ~= nil then
    func:ToBeDeletedEd();
    self._LibFtns[uid] = nil;
  end

end

function BlueFtnLib:GetLibFtns()
  return self._LibFtns;
end


function BlueFtnLib:_OnAwake(hostNode)
  for _, ftn in pairs(self._LibFtns) do
    ftn:_OnAwake(hostNode);
  end
end

function BlueFtnLib:OnDeserializeDone(hostNode)
  self:_OnAwake(hostNode);
end

-- 从大场景到prefab场景 清空引用列表  并且切换之后要重新OnAwake(EnterNextSceneEd)
function BlueFtnLib:LeaveCurrentSceneEd()
  for _, ftn in pairs(self._LibFtns) do
    ftn:LeaveCurrentSceneEd();
  end
end

function BlueFtnLib:EnterNextSceneEd(hostNode)
  for _, ftn in pairs(self._LibFtns) do
    ftn:EnterNextSceneEd(hostNode);
  end
end

function BlueFtnLib:GetErrorMessage()
  return self.errorMessage;
end

function BlueFtnLib:CompileCode(isPrefabMode)
  self.errorMessage = nil;
  local result = true
  for uid , ftn in pairs(self._LibFtns) do
    local compileFlag = ftn:CompileCode(isPrefabMode);
    result = compileFlag and result -- 其中一个编译出错,其他继续
    if not compileFlag then
      local funcVarCompileError = ftn:GetErrorMessage();
      local errMess = funcVarCompileError and funcVarCompileError or "ExecFlow"
      errMess = "function "..tostring(ftn:GetName()).." compile error! ".."\n\t\t\t\t"..errMess;
      local libName = self:GetLibName();
      self.errorMessage = self.errorMessage and self.errorMessage.."\n\t\t\t"..errMess or libName.." Compile Error\n\t\t\t"..errMess;
    end
  end
  return result
end

function BlueFtnLib:Run()
  for uid , ftn in pairs(self._LibFtns) do
    ftn:Run()
  end
end

function BlueFtnLib:Stop()
  for uid , ftn in pairs(self._LibFtns) do
    ftn:Stop()
  end
end


function BlueFtnLib:SyncEd()
  for uid , ftn in pairs(self._LibFtns) do
    ftn:SyncEd()
  end
end

return BlueFtnLib;