local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local BluePinInfo = require "bluecore.bluepininfo"
local Types = require "venuscore.rtti.types"
local mf = require "mathfunction"
local vc = require "libvenuscore"
local BFPI = require "bluecore.bluefuncpininfo"
local BlueRtti = require "bluecore.core.blue_rtti"

local BlueEventDispatcher = vc.Object:extend("BlueEventDispatcher");

function BlueEventDispatcher:new(graph, ...)
  BlueEventDispatcher.super.new(self, ...)
  self.graph = graph
  self._RefactorList = setmetatable({}, { __mode = 'v' })
  self._delegatesList = setmetatable({}, { __mode = 'k' })
end

-- 绑定 和 解除指定绑定  都只有两个引脚 固定
--    第一个数据引脚  蓝图类 blueprintType
--    第二个数据引脚  委托类型

-- 解除所有绑定
--    第一个数据引脚  蓝图类 blueprintType 只有一个引脚 固定

-- 调用
--    第一个数据引脚  是 蓝图类 blueprintType
--    其他数据引脚  是 参数输入

function BlueEventDispatcher:EditorCreate(dispatcherName, uid)

  self._myName = dispatcherName
  self._myUid = uid
  self._inputInfoArray = {}; -- 参数信息,带有默认值

  self:_SetupDelegateType(); -- 作为委托引脚的数据类型 用于匹配

  -- 新建,在自己new构造过程中注册;删除,在节点_OnDeleteEd中反注册
  -- 反序列化,由blueprint统一注册
  BlueRtti.AppendEventDispatcherToClassInfo(self.graph, self);

  self._CreatedDone = true

end



-- 事件代理类型 -- 实际就是参数的签名信息
-- 自定义事件节点 和 事件分发器的 签名信息 (参数按顺序类型和个数一样 EventDelegateType:isType)
function BlueEventDispatcher:_SetupDelegateType()
  local newType = Types.EventDelegateType:extend()
  newType:SetArgsInfo(self._inputInfoArray) -- 直接引用_inputInfoList
  self._eventDelegateType = newType         -- 需要加入classMap
end

function BlueEventDispatcher:_OnDeserialize()

  --BlueEventDispatcher.super:_OnDeserialize()

  self:_SetupDelegateType();
  -- _myName
  -- _myUid
  --  BlueRtti.AppendEventDispatcherToClassInfo(self.graph, self);

  for _, blueFuncPinInfo in pairs(self._inputInfoArray) do
    blueFuncPinInfo:SetOwner(self);
  end

  self._CreatedDone = true

end

function BlueEventDispatcher:GetName()
  return self._myName
end

function BlueEventDispatcher:GetUid()
  return self._myUid
end


function BlueEventDispatcher:AddArgumentEd() -- AddBlueFunctionInfo


  local arrayIndex = #self._inputInfoArray + 1

  local pinName = "New Param "..tostring(arrayIndex)

  local blueFuncPinInfo = BFPI(mf.vector3:GetTypeName(), false);
  blueFuncPinInfo:EditorCreate(true, pinName, "No Tips", self.graph:_NextID());
  blueFuncPinInfo:SetOwner(self); -- self is IChangeInfo implemented
  table.insert(self._inputInfoArray, blueFuncPinInfo)

  for _, dispatcherInfo in pairs(self._RefactorList) do
    dispatcherInfo:EditorPinAdd(true, blueFuncPinInfo)
  end

  return arrayIndex ; -- undo deleted
end


function BlueEventDispatcher:RemoveArgumentEd(arrayIndex)

  -- Declared -> Called
  for _, refactorInfo in pairs(self._RefactorList) do
    refactorInfo:EditorPinDelete(true, arrayIndex)
  end

  -- Defined
  table.remove(self._inputInfoArray, arrayIndex);

end


-- blueFuncPinInfo: is one of array 'self._inputInfoArray', blueFuncPinInfo was changed when this called
-- isInput: always is true
function BlueEventDispatcher:ChangeInfo(blueFuncPinInfo, type, val, isInput)

  if not isInput then error("BlueEventDispatcher input false") end

  local arrayIndex = nil
  for idx, info in pairs(self._inputInfoArray) do
    if info == blueFuncPinInfo then
      arrayIndex = idx
      break
    end
  end

  if arrayIndex == nil then error("CustomEventNode ChangeInfo no arrayIndex"); end

  -- 同步 DispatcherInfo (对于调用节点来说是输入引脚修改了)
  for _, refactor in pairs(self._RefactorList) do
    refactor:InfoChange(arrayIndex, type, val, true);
  end

end


-- interface IInfoChange
--          InfoChange
--          EditorPinDelete
--          EditorPinAdd
function BlueEventDispatcher:AddRefactor(iInfoChange)
  if not iInfoChange.InfoChange      then error("BlueEventDispatcher missing InfoChange "); end
  if not iInfoChange.EditorPinDelete then error("BlueEventDispatcher missing EditorPinDelete "); end
  if not iInfoChange.EditorPinAdd    then error("BlueEventDispatcher missing EditorPinAdd "); end
  table.insert(self._RefactorList, iInfoChange)
end

function BlueEventDispatcher:RemoveRefactor(iInfoChange)
  if _KRATOSEDITOR then
    for idx, cb in pairs(self._RefactorList) do
      if cb == iInfoChange then
        self._RefactorList[idx] = nil
      end
    end
  end
end


function BlueEventDispatcher:GetInputInfo()
  return self._inputInfoArray ;
end


function BlueEventDispatcher:ToBeDeletedEd()

  -- ClassInfo.DispatcherInfo:ToBeDeletedEd(Defined)
  -- --> ClassInfo:ToBeDeletedEd(Declared)
  -- --> bind/unbind/callEventDispatcher:ToBeDeletedEd(Called)

  for _, dispatcherInfo in pairs(self._RefactorList) do
    dispatcherInfo:ToBeDeletedEd()
  end

end


function BlueEventDispatcher:AddDelegate(customNode)
  self._delegatesList[customNode] = true
end

function BlueEventDispatcher:RemoveDelegate(customNode)
  self._delegatesList[customNode] = nil
end

function  BlueEventDispatcher:Dispatch(args)
  for delegate, _ in pairs(self._delegatesList) do
    local blueprint = delegate.graph
    local eventName = delegate:GetEventName();
    blueprint:SetCustomEventRunLabel(true, eventName);
    blueprint[eventName](blueprint, args)
    blueprint:SetCustomEventRunLabel(false);
  end -- no return
end

function BlueEventDispatcher:RemoveAllDelegate()
  self._delegatesList = setmetatable({}, { __mode = 'k' })
end

function BlueEventDispatcher:_GetName()
  return self._myName
end

function BlueEventDispatcher:_SetName(name)
  local oldName = self._myName
  self._myName = name
  if self._CreatedDone then
    for _, dispatcherInfo in pairs(self._RefactorList) do
      dispatcherInfo:NameChanged(oldName,  name)
    end
  end
end

function BlueEventDispatcher:GetRefactorList()
  return self._RefactorList
end

BlueEventDispatcher:MemberRegister("_myName", Types.StringType(BlueEventDispatcher._GetName, BlueEventDispatcher._SetName));
BlueEventDispatcher:MemberRegister("_myUid")
BlueEventDispatcher:MemberRegister("_inputInfoArray");
-- 不使用只支持序列化的BluePinInfo,使用支持反射和序列化的BlueFunctionPinInfo

return BlueEventDispatcher;