local vc = require "libvenuscore"
local BD = require "bluecore.bluedefined"


local ArgInfo = vc.Object:extend("ArgInfo");

function ArgInfo:new()

end

local function getBR()
  local BR = require "bluecore.core.blue_rtti"
  getBR = function()
    return BR
  end
  return BR
end


function ArgInfo:RegisterBlueFunPinInfo(bluefuncpininfo)

  local info = bluefuncpininfo;

  self.baseRttiName = info.base_rtti_name
  self.rtti = info.rtti ;
  self.baseRtti = info.base_rtti ;
  self.isInput = info.isInput;
  self.name = info.name;
  --self.is_private = is_private or true
  --self.is_const = is_const or false
  --self.is_final = is_final or false;
  self.tips =info.tips ;
  self.isRef = info.isRef ;
  self.defaultValue = info.default_value
  self.isArray = info.is_array or false

  self.argUid = info.argUid
end

function ArgInfo:ChangeRtti(rtti, default)

  if rtti == nil then
    error("ArgInfo:ChangeRtti rtti is nil");
  end
  if self.isInput and default == nil then
    -- 对于Node Component BlueprintType类型来说 输入的默认值的确是nil 字面值为nil 必须连接
    local BU = require "bluecore.blueutility"
    assert(BU:GetDefaultByRtti(rtti) == nil, "ArgInfo:ChangeRtti default is needed for input");
  end
  self.rtti = rtti
  self.isArray = self.rtti:isArray();
  if self.isArray then
    self.baseRtti =  self.rtti:GetElementType();
    self.baseRttiName = self.baseRtti:GetTypeName();
  else
    self.baseRtti = rtti ;
    self.baseRttiName = self.rtti:GetTypeName();
  end
  self.defaultValue = default ;
end

function ArgInfo:ChangeName(_name)
  self.name = _name
end

function ArgInfo:ChangeDefault(_default)
  self.defaultValue = _default
end

-- SerializationTool:_SerializeCls
function ArgInfo:_ReOrder(jsonTable, attributes)

  local typeName = jsonTable["typename"]
  local value = jsonTable["value"]
  if typeName == "number" then
    return value
  elseif typeName == "boolean" then
    return value
  elseif typeName == "string" then
    return value
  elseif typeName == vc.ScriptTypes.ReferenceTypeName then
    return value
  end

  attributes["__typename"] = typeName

  local memberTable = jsonTable["members"]
  for k1, v1 in pairs(memberTable) do
    attributes[k1] = {}
    local value1 = self:_ReOrder(v1, attributes[k1])
    if value1 ~= nil then
      attributes[k1] = value1
    end
  end
end

-- json全部都是字符串 没有转换成对应类型
function ArgInfo:RegisterPrefab(prefabJson)

  local info = prefabJson;

  self.baseRttiName = info.base_rtti_name

  self.isInput = info.isInput == "true"
  self.name = info.name;
  --self.is_private = is_private or true
  --self.is_const = is_const or false
  --self.is_final = is_final or false;
  self.tips =info.tips ;
  self.isRef = info.isRef == "true"
  self.isArray = info.is_array == "true"

  self.argUid = tonumber(prefabJson.argUid)

  local BundleSystem = require "venuscore.bundle.bundlesystem"


  if info.default_value ~= nil then
    local attributes = {}
    local value1 = self:_ReOrder(info.default_value, attributes)
    if value1 ~= nil then
      self.defaultValue = value1
    else
      local func = BundleSystem:GetDeserializationCallback(attributes["__typename"]);
      local obj = func(attributes, nil, nil, nil, nil, nil, nil); -- host is nil
      self.defaultValue = obj
    end
  else -- Node/Component引用类型或者蓝图类类型,作为函数参数是没有默认值
    WARNING(string.format("arg_info name:%s default is nil", self.name))
    self.defaultValue = nil
  end



  local baseRtti, rttiOfArray = getBR().GetRtti(self.baseRttiName, self.isArray)

  if self.isArray then
    self.baseRtti = baseRtti ;
    self.rtti = rttiOfArray ;
  else
    self.baseRtti = baseRtti ;
    self.rtti = baseRtti ;
  end
end


function ArgInfo:GetBaseRttiName()
  return self.baseRttiName
end

function ArgInfo:GetIsArray()
  return  self.isArray
end


-- 与 BlueFuncPinInfo 保持一致
function ArgInfo:GetRtti()
  return self.rtti
end

function ArgInfo:GetDefault()
  return self.defaultValue
end

function ArgInfo:GetTips()
  return self.tips
end

function ArgInfo:GetName()
  return self.name
end


function ArgInfo:Dump()
  LOG("------         name "..tostring(self.name))
  LOG("------ baseRttiName "..tostring(self.baseRttiName))
  LOG("------     baseRtti "..tostring(self.baseRtti))
  LOG("------      isArray "..tostring(self.isArray))
  LOG("------         rtti "..tostring(self.rtti))
  LOG("------      isInput "..tostring(self.isInput))
  LOG("------         tips "..tostring(self.tips))
  LOG("------        isRef "..tostring(self.isRef))
  LOG("------ defaultValue "..tostring(self.defaultValue))

end

return ArgInfo ;