local BN = require "bluecore.bluenode"
local BD = require "bluecore.bluedefined"
local AE = require "apolloengine"
local ED = require "bluecore.eventdispatcher"
local Types = require "venuscore.rtti.types"

local ScaleGesture = BN:extend();

function ScaleGesture:new(...)
  ScaleGesture.super.new(self, ...)
end

local BEGIN = AE.SensorsTrackingComponent.VALUE_GESTURE_BEGIN
local KEEP = AE.SensorsTrackingComponent.VALUE_GESTURE_KEEP
local END = AE.SensorsTrackingComponent.VALUE_GESTURE_END

function ScaleGesture:_OnUpdate(eventParam)
  local result = eventParam
  local event = result.value -- begin/keep/move
  if event ~= nil then
    if event == BEGIN then
      self.nextExecIdx = 1
      return 0, 0, 0
    elseif event == KEEP then
      local scale = result.z
      local x = result.x
      local y = result.y
      self.nextExecIdx = 2
      return scale, x, y
    elseif event == END then
      self.nextExecIdx = 3
      return 0, 0, 0
    else
      ERROR("[ScaleGesture] unknown event "..event);
    end
  end
  self.nextExecIdx = 0 -- break exec
end

function ScaleGesture:_OnNextBranch()
  return self.nextExecIdx
end

function ScaleGesture:RegisterTriggerFunc(func, bluePrintSelf)

  ED:RegisterCallback(
          BD.Event.GestureScalePath,
          BD.Event.GestureGlobalEvent.GESTURE_BEGIN,
          func,
          bluePrintSelf);

  ED:RegisterCallback(
          BD.Event.GestureScalePath,
          BD.Event.GestureGlobalEvent.GESTURE_KEEP,
          func,
          bluePrintSelf);

  ED:RegisterCallback(
          BD.Event.GestureScalePath,
          BD.Event.GestureGlobalEvent.GESTURE_END,
          func,
          bluePrintSelf);

  AE.IActionSystem:AddClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_SCALE,
          bluePrintSelf.Node:GetComponent(AE.Node.CT_BLUEPRINT), 0);
end

function ScaleGesture:_OnStop()
  -- ED:RegisterCallback -- Do not Need,blueprint Stop() will unregister all
  AE.IActionSystem:RemoveClient(
          AE.SensorsTrackingComponent.VENUS_SENSOR_GESTURE_SCALE,
          self.graph.Node:GetComponent(AE.Node.CT_BLUEPRINT));

end


ScaleGesture:RegisterOutput(1, Types.FloatType, "scale", "current/last, scale is valid when 'keep' ")
ScaleGesture:RegisterOutput(2, Types.FloatType, "x", "scale center x")
ScaleGesture:RegisterOutput(3, Types.FloatType, "y", "scale center y")

ScaleGesture:RegisterExecOutput(1, "begin", "begin to scale");
ScaleGesture:RegisterExecOutput(2, "keep", "keep scaling");
ScaleGesture:RegisterExecOutput(3, "stop", "stop scaling");

ScaleGesture:SetFunctionName("Scale Gesture");
ScaleGesture:SetFunctionType(BD.EVENT_FUNCTION_NODE);
ScaleGesture:SetEventType(BD.EventType.RegisterCallback);

return ScaleGesture;
