local BlueUtility = require "bluecore.blueutility"
local BlueNode = require "bluecore.bluenode"

local Sequence5 = BlueNode:extend();

function Sequence5:new(...)
	Sequence5.super.new(self,...);
end


function Sequence5:Update(_execIdx)
  for i = 1, 5 do
    local nextIdx = self.nextExecIndex[i];
    local nextNode = self.nextExecNodes[i];
    local lastNode = self;
    local execIdx = i;
    while nextNode ~= nil
    do
      if _KRATOSEDITOR then
        local link_uid = lastNode.execOutputs[execIdx].links[1].linkUid;
        self.graph:AddExecLinkList(link_uid);
      end
      lastNode = nextNode;
      execIdx = nextNode:Update(nextIdx);
      nextIdx  = nextNode.nextExecIndex[execIdx];
      nextNode = nextNode.nextExecNodes[execIdx];
    end
  end
end

Sequence5:RegisterExecInput(1, "exec", "Execute");

Sequence5:RegisterExecOutput(1, "exec", "Execute");
Sequence5:RegisterExecOutput(2, "exec", "Execute");
Sequence5:RegisterExecOutput(3, "exec", "Execute");
Sequence5:RegisterExecOutput(4, "exec", "Execute");
Sequence5:RegisterExecOutput(5, "exec", "Execute");
Sequence5:SetFunctionName("Sequence5");

return Sequence5 ;