
local libvenuscore = require "libvenuscore"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local SetActive = BlueNode:extend();

---- 游戏运行模式
function SetActive:new(...)
  SetActive.super.new(self,...);
end

function SetActive:_OnUpdate(args)
  if args[2] == true then
    args[1]:Activate();
  else
    args[1]:Deactivate();
  end

end


---- 编辑器模式

SetActive:RegisterInput(1, apolloengine.CameraComponent:RTTI(), "target", "相机节点", BlueSelf());
SetActive:RegisterInput(2, Types.BoolType, "status", "设置相机状态", true);

SetActive:RegisterExecInput(1, "exec", "Execute");

SetActive:RegisterExecOutput(1, "exec", "Execute");


SetActive:SetFunctionName("SetCameraActive");

return SetActive ;