
local venuscore = require "venuscore"
local mathfunction = require "mathfunction"
local apollocore = require "apollocore"
local defined = require "apolloengine.defined"
local BundleSystem = require "venuscore.bundle.bundlesystem"


local _fNativeGetScene = apollocore.SceneManager.GetScene;
local _fNativeCreateScene = apollocore.SceneManager.CreateScene;
local _fNativeGetSceneByID = apollocore.SceneManager.GetSceneById;
local _fNativeDeleteSceneByID = apollocore.SceneManager.DeleteSceneById;
local _fNativeGetAllScene = apollocore.SceneManager.GetAllScenes;



function apollocore.SceneManager:CreateScene(sceneName)
  local scene = _fNativeCreateScene(self,sceneName);
  if _KRATOSEDITOR then
    scene:Init();
    apollocore.SceneManager.EditCamera = scene:CreateEditorCamera();
    apollocore.SceneManager.EditCamera2D = scene:CreateEditorCamera2D();
    apollocore.SceneManager.FaceEditorCamera = scene:CreateFaceEditorCamera();
    apollocore.SceneManager.Grid = scene:CreateGrid();
    apollocore.SceneManager.EditSceneID = scene:GetStaticID();
    scene:SetPhyscisDebugMesh(true);
    scene:SetEditorCamera(apollocore.SceneManager.EditCamera:GetComponent(apollocore.Node.CT_CAMERA));
  end
  return scene;
end

function apollocore.SceneManager:DeleteSceneByID(sceneID)
  if sceneID then
    _fNativeDeleteSceneByID(self,sceneID);
    if apollocore.SceneManager.referenceinfos then
      apollocore.SceneManager.referenceinfos[sceneID] = nil;
    end
  end
end


function apollocore.SceneManager:SetReference(sceneId, referenceinfo)
  apollocore.SceneManager.referenceinfos = apollocore.SceneManager.referenceinfos or {};
  apollocore.SceneManager.referenceinfos[sceneId] = referenceinfo;
end
  
function apollocore.SceneManager:GetReference(sceneId)
  if apollocore.SceneManager.referenceinfos and apollocore.SceneManager.referenceinfos[sceneId] then
    return apollocore.SceneManager.referenceinfos[sceneId];
  end
  return nil;
end


function apollocore.SceneManager:LoadScene(assetPath)
  local scene = BundleSystem:DeserializeFromPath(assetPath, BundleSystem.DeserializeMode.Scene)
  return scene;
end

--避免修改facecute
--和之前的GetOrCreate兼容
--这里兼容下用Name索引Scene
apollocore.SceneManager.SceneType2SceneIDList = {};
function apollocore.SceneManager:GetOrCreateScene(sceneType)
  local scene = nil;
  local sceneID = apollocore.SceneManager.SceneType2SceneIDList[sceneType];
  if sceneID then
    scene = _fNativeGetSceneByID(self,sceneID);
  else
    scene = _fNativeCreateScene(self,sceneType);  --直接拿sceneType当名字
    apollocore.SceneManager.SceneType2SceneIDList[sceneType] = scene:GetStaticID();
  end
  return scene;
end

function apollocore.SceneManager:GetSceneByType(sceneType)
  local scene = nil;
  local sceneID = apollocore.SceneManager.SceneType2SceneIDList[sceneType];
  if sceneID then
    scene = _fNativeGetSceneByID(self,sceneID);
  end
  return scene;
end

function apollocore.SceneManager:CreateSceneByType(sceneType)
  local scene = _fNativeCreateScene(self,sceneType);
  apollocore.SceneManager.SceneType2SceneIDList[sceneType] = scene:GetStaticID();
  return scene;
end


function apollocore.SceneManager:UpdateMakeupMask(def)
  if apollocore.SceneManager.makeup_mark_irisL then
    apollocore.SceneManager.makeup_mark_irisL:GetRefObj():Update(def);
    apollocore.SceneManager.makeup_mark_irisL:GetRefObj():LateUpdate(def);
  end
  if apollocore.SceneManager.makeup_mark_irisR then
    apollocore.SceneManager.makeup_mark_irisR:GetRefObj():Update(def);
    apollocore.SceneManager.makeup_mark_irisR:GetRefObj():LateUpdate(def);
  end
end

if _KRATOSEDITOR then
  apollocore.SceneManager.PreviewSceneID = nil;
  apollocore.SceneManager.EditSceneID = nil;
  apollocore.SceneManager.EditorUIID = nil;
  apollocore.SceneManager.EditCamera = nil;
  apollocore.SceneManager.EditCamera2D = nil;
  apollocore.SceneManager.FaceEditorCamera = nil;
  apollocore.SceneManager.Grid = nil;
  apollocore.SceneManager.SyncSceneList = {};
  
  function apollocore.SceneManager:GetEditCamera()
    return apollocore.SceneManager.EditCamera;
  end

  function apollocore.SceneManager:GetEditCamera2D()
    return apollocore.SceneManager.EditCamera2D;
  end

  function apollocore.SceneManager:GetFaceEditorCamera()
    return apollocore.SceneManager.FaceEditorCamera;
  end
  
  function apollocore.SceneManager:GetGrid()
    return apollocore.SceneManager.Grid;
  end
  
  function apollocore.SceneManager:CreatePreviewScene(sceneName)
    local previewScene = _fNativeCreateScene(self,sceneName);
    previewScene:SetSequence(defined.SceneSequence.MID);
    apollocore.SceneManager.PreviewSceneID = previewScene:GetStaticID();
    return previewScene;
  end
  
  function apollocore.SceneManager:GetPreviewScene()
    local previewScene = nil;
    if apollocore.SceneManager.PreviewSceneID then
      previewScene = _fNativeGetSceneByID(self,apollocore.SceneManager.PreviewSceneID);
    end
    return previewScene;
  end
  
  function apollocore.SceneManager:SetPreviewScene(previewScene)
    apollocore.SceneManager = previewScene:GetStaticID();
    previewScene:SetSequence(defined.SceneSequence.MID);
  end
  
  
  function apollocore.SceneManager:GetEditScene()
    local scene = nil;
    if apollocore.SceneManager.EditSceneID then
      scene = _fNativeGetSceneByID(self,apollocore.SceneManager.EditSceneID);
    end
    return scene;
  end
  
  function apollocore.SceneManager:GetEditSceneID()
    return apollocore.SceneManager.EditSceneID;
  end

  function apollocore.SceneManager:GetUISceneID()
    if apollocore.SceneManager.EditorUIID == nil then
      local scenes = _fNativeGetAllScene(self);
      for k,v in pairs(scenes) do
        local name = v:GetName();
        if name == "EditorUI" then
          apollocore.SceneManager.EditorUIID = v:GetStaticID();
        end
      end
    end
    return apollocore.SceneManager.EditorUIID;
  end
  
  --编辑器模式下清理Scene
  function apollocore.SceneManager:ClearScene()
    --删除EditorScene
    local editScene = _fNativeGetSceneByID(self,apollocore.SceneManager.EditSceneID);
    if editScene then
      apollocore.SceneManager.EditCamera = nil;
      apollocore.SceneManager.EditCamera2D = nil;
      apollocore.SceneManager.Grid = nil;

      -- DeleteEditScene
      editScene:SetMainCamera(nil);
      local rootNode = editScene:GetRootNode();
      local childNodes = rootNode:GetChildrens();
      for i = 1, #childNodes do
        editScene:DeleteNode(childNodes[i]);
      end
      local compList = rootNode.Components;
      if compList then
        for key,value in pairs(compList) do
          value:Destroy();
        end
      end

      _fNativeDeleteSceneByID(self,apollocore.SceneManager.EditSceneID);
      --清理其他Scene的Node(其他的Scene不能删除)
      if apollocore.SceneManager.PreviewSceneID then
        local preViewScene = _fNativeGetSceneByID(self,apollocore.SceneManager.PreviewSceneID);
        if preViewScene then

          -- DeleteGameScene
          preViewScene:SetMainCamera(nil); --将主相机清理掉
          rootNode = preViewScene:GetRootNode();
          childNodes = rootNode:GetChildrens(); --把root的自node都删除掉
          for i = 1, #childNodes do
            preViewScene:DeleteNode(childNodes[i]);
          end
          compList = rootNode.Components;
          --if compList then
          --  for key,value in pairs(compList) do
          --    value:Destroy();
          --  end
          --end
          if compList then -- Destroy() do not detach component from node
            for key, value in pairs(compList) do
              rootNode:DeleteComponent(key); -- it will call comp:Destroy too
            end
          end

        end
      end
    end
    apollocore.SceneManager.referenceinfos = {};
  end

  --编辑器模式下拿到命令需要同步到的场景
  function apollocore.SceneManager:AddSyncScene(scene)
    if scene then
      local sceneID = scene:GetStaticID();
      if apollocore.SceneManager.SyncSceneList[sceneID] == nil then
        apollocore.SceneManager.SyncSceneList[sceneID] = scene;
      end
    end
  end

  --彻底删除game场景并重建的时候需要清理掉原本的场景
  function apollocore.SceneManager:ClearSyncScene(scene)
    local sceneID = scene:GetStaticID();
    apollocore.SceneManager.SyncSceneList[sceneID] = nil;
  end

  
  function apollocore.SceneManager:GetSyncSceneList()
    return apollocore.SceneManager.SyncSceneList;
  end


  function apollocore.SceneManager:DeleteEditScene()
    --删除EditorScene
    local editScene = _fNativeGetSceneByID(self,apollocore.SceneManager.EditSceneID);
    if editScene then
      apollocore.SceneManager.EditCamera = nil;
      apollocore.SceneManager.EditCamera2D = nil;
      apollocore.SceneManager.Grid = nil;

      editScene:SetMainCamera(nil); --将主相机清理掉
      local rootNode = editScene:GetRootNode();
      --把root的子node都删除掉
      local childNodes = rootNode:GetChildrens();
      for i = 1, #childNodes do
        editScene:DeleteNode(childNodes[i]);
      end
      -- rootNode需要给scene DetachNode, 所以这里只删除rootnode下的compoent
      local compList = rootNode.Components;
      if compList then
        for key,value in pairs(compList) do
          value:Destroy();
          end
      end

      _fNativeDeleteSceneByID(self,apollocore.SceneManager.EditSceneID);
    end
    apollocore.SceneManager.referenceinfos = {};
  end

  function apollocore.SceneManager:DeleteGameScene()
    if apollocore.SceneManager.PreviewSceneID then
      local preViewScene = _fNativeGetSceneByID(self,apollocore.SceneManager.PreviewSceneID);
      if preViewScene then
        preViewScene:SetMainCamera(nil); --将主相机清理掉
        local rootNode = preViewScene:GetRootNode();
        --把root的自node都删除掉
        local childNodes = rootNode:GetChildrens();
        for i = 1, #childNodes do
          preViewScene:DeleteNode(childNodes[i]);
        end
        local compList = rootNode.Components;
        if compList then
          for key,value in pairs(compList) do
            value:Destroy();
          end
        end

      end
      _fNativeDeleteSceneByID(self,apollocore.SceneManager.PreviewSceneID);
    end
  end
  
  --编辑器下GetOrCreate就是GetPreviewScene
  apollocore.SceneManager.GetOrCreateScene = apollocore.SceneManager.GetPreviewScene;
end








