local apollocore = require "apollocore"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local cv = require "computervisionfunction"
local mf = require "mathfunction"

local gStructDataFunction = {}

--[[local allCVTypes = cv.RecognitionComponent:GetAllAvailableCVType();
for k,v in pairs(allCVTypes) do
  EventDispatcher:RegisterEvent(cv.RecognitionComponent:GetTypeName(), k);
end]]--
local _fNativeUpdate = apollocore.IComponent.Update;

local gLastEvent = {}
local _fNativeDestroy = apollocore.IComponent.Destroy;
rawset(cv.RecognitionComponent, "Destroy", function(self)
  local staticID =  self:GetContentPath();
  --for id, _ in pairs(gLastEvent) do
  --  ERROR("Recognition LastEvent staticID: "..tostring(id))
  --end
  gLastEvent[staticID] = nil
  _fNativeDestroy(self);
end);

rawset(cv.RecognitionComponent, "ResetCached", function(self)
  local staticID =  self:GetContentPath();
  gLastEvent[staticID] = nil
end);


local _UpdateFunc = function(self, def)
  _fNativeUpdate(self,def);

  local staticID =  self:GetContentPath();
  -- 只有有这个Comp的监听者才分发
  if EventDispatcher:HasCompListener(staticID) then

    local lastEvents = gLastEvent[staticID];
    gLastEvent[staticID] = nil
    local currentEvents = {}

    local results = self:GetResult();
    if next(results) ~= nil then
      for k, v in pairs(results) do
        -- 只有有这个事件的监听者才分发
        if EventDispatcher:HasEventListener(staticID, k) then
          -- 只过滤事件 具体哪个人的由事件节点过滤
          local event = {
            staticID = staticID;
            eventType = k;
          };
          if gStructDataFunction[k] ~= nil then
            event.params = gStructDataFunction[k](self, v);
          else
            event.params = v;
          end

          if lastEvents and lastEvents[k] then
            lastEvents[k] = false
          end
          currentEvents[k] = true
          EventDispatcher:PushEvent(event);

        end

        -- 人脸事件,需要另外判断(但是不struct数据),是否有监听人脸事件(虚拟)
        if k == cv.RecognitionComponent.cvFace then
          local HAS_FACE_EVENT = BD.Event.VirtualEvent.HasFace
          if EventDispatcher:HasEventListener(staticID, HAS_FACE_EVENT) then
            local params = self:_StructFaceIdData(v);
            if params ~= nil and next(params) ~= nil then
              local event = {
                staticID = staticID;
                eventType = HAS_FACE_EVENT;
                params = params -- 人脸列表
              };

              if lastEvents and lastEvents[HAS_FACE_EVENT] then
                lastEvents[HAS_FACE_EVENT] = false
              end
              currentEvents[HAS_FACE_EVENT] = true
              EventDispatcher:PushEvent(event);
            end
          end
        end
      end
    end

    gLastEvent[staticID] = currentEvents;

    if lastEvents then
      for eventType, flag in pairs(lastEvents) do
        if flag then -- 代表上次update有这个事件 这次update没有这个事件(代表没有一个人脸)
          local event = {
            staticID = staticID;
            eventType = eventType;
            params = nil, -- 代表当前帧这个事件
          };
          EventDispatcher:PushEvent(event);
        end
      end
    end

  else
    gLastEvent[staticID] = nil -- may not recycle memory ?
  end
end
rawset(cv.RecognitionComponent, "Update", _UpdateFunc);


function cv.RecognitionComponent:_StructFaceAttributeData(cvFaceAttrArray)

  if cvFaceAttrArray == nil then
    return
  end

  local humanCount = #cvFaceAttrArray;
  if humanCount == 0 then
    return
  end

  local formatFaceAttributeArray = {}

  for humanId = 1, humanCount do

    local attrData = cvFaceAttrArray[humanId]

    local structFaceAttr = {
      man =    attrData[1] ,--> 0.5 man
      yellow = attrData[3] , -- 只是给出分数
      black =  attrData[5] ,
      white =  attrData[7] ,
      India =  attrData[9], -- > 0.5 India
      age   =  attrData[11] ,
      beauty = attrData[13],
    }
    
    table.insert(formatFaceAttributeArray, structFaceAttr)

  end

  return formatFaceAttributeArray

end



function cv.RecognitionComponent:_StructIrisData(cvIrisArray)

  if cvIrisArray == nil then
    return
  end

  local humanCount = #cvIrisArray;
  if humanCount == 0 then
    return
  end

  local size = self:GetDetectSize();
  local width = size:x();
  local height = size:y();

  local formatIrisArray = {}

  for faceId = 1, humanCount do

    local structIris = {                  -- 坐标目前没有归一化
      leftEyeCenter = mf.vector2(0,0),    -- 左眼中心点
      rightEyeCenter = mf.vector2(0,0),   -- 右眼中心点
      leftEyeLankmark = {},               -- 左眼轮廓点--20个 最后一个也是左眼中心点(保持与bvt一样的信号格式)
      rightEyeLankmark = {}               -- 右眼轮廓点--20个 最后一个也是右眼中心点
    }

    local irisData = cvIrisArray[faceId]

    for i = 1, 20 do
      table.insert(structIris.leftEyeLankmark, mf.vector2(irisData[i * 2 - 1]/width,  irisData[i * 2]/height));
    end

    for i = 1, 20 do
      table.insert(structIris.rightEyeLankmark, mf.vector2(irisData[(i+20) * 2 - 1]/width, irisData[(i+20) * 2]/height));
    end

    structIris.leftEyeCenter = mf.vector2(irisData[20 * 2 - 1]/width, irisData[20 * 2]/height)
    structIris.rightEyeCenter = mf.vector2(irisData[40 * 2 - 1]/width, irisData[40 * 2]/height)

    table.insert(formatIrisArray, structIris)

  end

  return formatIrisArray

end

function cv.RecognitionComponent:_StructAdvanceData(cv134Array)

  if cv134Array == nil then
    return
  end

  local humanCount = #cv134Array;
  if humanCount == 0 then
    return
  end

  local format134Array = {}

  local size = self:GetDetectSize();
  local width = size:x();
  local height = size:y();

  for faceId = 1, humanCount do

    local structFace134 = {
      landmark = {}
    }

    local advanceData = cv134Array[faceId]
    for i = 1, 134 do
      table.insert(structFace134.landmark, mf.vector2(advanceData[i * 2 - 1]/width, advanceData[i * 2]/height));
    end

    table.insert(format134Array, structFace134)

  end

  return format134Array

end


function cv.RecognitionComponent:_StructFaceIdData(cvFaceArray)
  if cvFaceArray == nil then
    return
  end

  local faceCount = #cvFaceArray;
  if faceCount == 0 then
    return
  end

  local formatFaceArray = {}
  for faceId = 1, faceCount do
    table.insert(formatFaceArray, faceId)
  end

  return formatFaceArray

end

function cv.RecognitionComponent:_StructFaceData(cvFaceArray)
  if cvFaceArray == nil then
    return
  end

  local faceCount = #cvFaceArray;
  if faceCount == 0 then
    return
  end

  local size = self:GetDetectSize();
  local width = size:x();
  local height = size:y();

  local formatFaceArray = {}

  for faceId = 1, faceCount do

    local structFace106 = {
      position = mf.vector2(0,0), -- 人脸框左上角坐标
      size = mf.vector2(0,0),     -- 人脸框尺寸
      landmark = {},              -- 106关键点 array, elementType is vector2
      euler = mf.vector3(0,0,0),  -- 欧拉角
      visibility = {}             -- 是否可见 array, elementType is bool
    }

    -- 106人脸点
    local faceData = cvFaceArray[faceId];
    for i = 1, 106 do
      table.insert(structFace106.landmark,
              mf.vector2(faceData[i * 2 - 1]/width, faceData[i * 2]/height));
    end

    -- 人脸框
    structFace106.position = mf.vector2(faceData[107 * 2 - 1]/width, faceData[107 * 2]/height)
    structFace106.size = mf.vector2(faceData[108 * 2 - 1]/width, faceData[108 * 2]/height)

    -- 欧拉角
    local pyr = {}
    pyr[1] = faceData[109 * 2 - 1]
    pyr[2] = faceData[110 * 2 - 1]
    pyr[3] = faceData[111 * 2 - 1]
    structFace106.euler = mf.vector3(pyr[1], pyr[2], pyr[3])

    -- 是否可见
    for i = 112, 217 do
      table.insert(structFace106.visibility,faceData[i * 2 - 1] > 0.0)
    end

    table.insert(formatFaceArray, structFace106)
  end

  return formatFaceArray

end


-- 获取指定人的Face106结构化数据(归一化) structFace106
function cv.RecognitionComponent:GetFace106(faceId)

  local structFace106 = {
    position = mf.vector2(0,0), -- 人脸框左上角坐标
    size = mf.vector2(0,0),     -- 人脸框尺寸
    landmark = {},              -- 106关键点 array, elementType is vector2
    euler = mf.vector3(0,0,0),  -- 欧拉角
    visibility = {}             -- 是否可见 array, elementType is bool
  }

  local faceData = self:GetResultByTypeAndBodyIdx(cv.RecognitionComponent.cvFace, faceId);

  if next(faceData) == nil then
    return structFace106
  end

  local size = self:GetDetectSize();
  local width = size:x();
  local height = size:y();

  -- 106人脸点
  for i = 1, 106 do
    table.insert(structFace106.landmark,
            mf.vector2(faceData[i * 2 - 1]/width, faceData[i * 2]/height));
  end

  -- 人脸框
  structFace106.position = mf.vector2(faceData[107 * 2 - 1]/width, faceData[107 * 2]/height)
  structFace106.size = mf.vector2(faceData[108 * 2 - 1]/width, faceData[108 * 2]/height)

  -- 欧拉角
  local pyr = {}
  pyr[1] = faceData[109 * 2 - 1]
  pyr[2] = faceData[110 * 2 - 1]
  pyr[3] = faceData[111 * 2 - 1]
  structFace106.euler = mf.vector3(pyr[1], pyr[2], pyr[3])

  -- 是否可见
  for i = 112, 217 do
    table.insert(structFace106.visibility,faceData[i * 2 - 1] > 0.0)
  end

  return structFace106

end

-- 获取指定人格外的134点(归一化) structFace134
function cv.RecognitionComponent:GetAdvance134(faceId)

  local structFace134 = {
    landmark  = {},   --  Advanced关键点(实际是240-106=134个关键点)  array, elementType is vector2
  }

  local advanceData = self:GetResultByTypeAndBodyIdx(cv.RecognitionComponent.cvAdvancedLandmark, faceId);
  if next(advanceData) == nil then
    return structFace134
  end

  local size = self:GetDetectSize();
  local width = size:x();
  local height = size:y();


  for i = 1, 240 do
    table.insert(structFace134.landmark, mf.vector2(advanceData[i * 2 - 1]/width, advanceData[i * 2]/height));
  end
  return structFace134
end


function cv.RecognitionComponent:GetTongue(faceId)

  local structTongue = {
    score = 0.0 ,
    faceId = faceId ,
  }

  local tongueData = self:GetResultByTypeAndBodyIdx(cv.RecognitionComponent.cvTongueDetection, faceId);
  if next(tongueData) == nil then
    return structTongue
  end

  structTongue.score = tongueData[1]

  return structTongue
end


-- 获取指定人脸的iris 瞳孔的结构化数据 structIris
function cv.RecognitionComponent:GetIris(faceId)

  local structIris = {
    leftEyeCenter = mf.vector2(0,0),    -- 左眼中心点
    rightEyeCenter = mf.vector2(0,0),   -- 右眼中心点
    leftEyeLankmark = {},               -- 左眼轮廓点--20个 最后一个也是左眼中心点(保持与bvt一样的信号格式)
    rightEyeLankmark = {}               -- 右眼轮廓点--20个 最后一个也是右眼中心点
  }

  local irisData = self:GetResultByTypeAndBodyIdx(cv.RecognitionComponent.cvIrisDetection, faceId);

  local faceData = self:GetResultByTypeAndBodyIdx(cv.RecognitionComponent.cvFace, faceId);

  local size = self:GetDetectSize();
  local width = size:x();
  local height = size:y();


  -- 保证如果有106人脸点,就有眼球中心点
  if next(faceData) ~= nil then
    structIris.leftEyeCenter = mf.vector2(faceData[105 * 2 - 1]/width, faceData[105 * 2]/height)
    structIris.rightEyeCenter = mf.vector2(faceData[106 * 2 - 1]/width, faceData[106 * 2]/height)
  end

  if next(irisData) == nil then
    return structIris
  end


  for i = 1, 20 do
    table.insert(irisData.leftEyeLankmark, mf.vector2(irisData[i * 2 - 1]/width,  irisData[i * 2]/height));
  end

  for i = 1, 20 do
    table.insert(irisData.rightEyeLankmark, mf.vector2(irisData[(i+20) * 2 - 1]/width, irisData[(i+20) * 2]/height));
  end

  structIris.leftEyeCenter = mf.vector2(irisData[20 * 2 - 1]/width, irisData[20 * 2]/height)
  structIris.rightEyeCenter = mf.vector2(irisData[40 * 2 - 1]/width, irisData[40 * 2]/height)

  return structIris
end



gStructDataFunction[cv.RecognitionComponent.cvFace] = cv.RecognitionComponent._StructFaceData
gStructDataFunction[cv.RecognitionComponent.cvIrisDetection] = cv.RecognitionComponent._StructIrisData
gStructDataFunction[cv.RecognitionComponent.cvAdvancedLandmark] = cv.RecognitionComponent._StructAdvanceData
gStructDataFunction[cv.RecognitionComponent.cvFaceAttribution] = cv.RecognitionComponent._StructFaceAttributeData
