
#DEFPARAMS
RGB_TEXTURE = { "main Color", TEXTURE2D, "0.0,0.0" },
THRESHOLD = {"Threshold", FLOAT, "0.0"},
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "ShineLight"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_BACK, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D RGB_TEXTURE; 
SamplerState RGB_TEXTURE_Sampler;
float THRESHOLD;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}


void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#ifdef POST_EFFECT_ALPHA_OFF
		float threshold = float(THRESHOLD);
		float3 rgb = RGB_TEXTURE.Sample(RGB_TEXTURE_Sampler, i.uv).xyz + 0.5 / 255.0;
		float3 coeff = float3(0.299, 0.587, 0.114);
		float bright = dot(coeff, rgb);
		float3 finalRgb = bright > threshold ? rgb : float3(0.0, 0.0, 0.0);
		mainColor = float4(finalRgb, 1.0);
	#elif POST_EFFECT_ALPHA_ON
		float threshold = float(THRESHOLD);
		float4 rgba = RGB_TEXTURE.Sample(RGB_TEXTURE_Sampler, i.uv) + 0.5 / 255.0;
		float3 coeff = float3(0.299, 0.587, 0.114);
		float bright = dot(coeff, rgba.rgb);
		float3 finalRgb = bright > threshold ? rgba.rgb : float3(0.0, 0.0, 0.0);
		mainColor = float4(finalRgb, rgba.a);
	#endif
}
ENDCG
#END