#DEFPARAMS
[Enum(RenderQueue)]
_RenderQueue = {"Render Queue", FLOAT, "1000"},
#END

#DEFTAG
ShaderName = "StandardPbrDeferredResolve"
RenderQueue = "%_RenderQueue"
#END


#DEFPASS DeferredShading
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM

#define USE_GLES_FBF_DEFERRED (VENUS_MRT_FRAMEBUFFER_FETCH && (SHADER_API_GLES || SHADER_API_GLES3))
#define USE_PLS_DEFERRED (VENUS_MRT_PLS && (SHADER_API_GLES || SHADER_API_GLES3))

#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_fwdadd
#pragma multi_compile_mrt_fbfetch
#include "lightpbr.inc"
#include "lightdeferred.inc"

struct appdata
{
    float4 vertex : POSITION;
    float2 uv : TEXCOORD0;
};

struct v2f
{
    float2 uv : TEXCOORD0;
    float4 vertex : SV_POSITION;
};


v2f vert(appdata v)
{
    v2f o;
    o.vertex = UniformNDC(v.vertex);
    o.uv = v.uv.xy;
    return o;
}


void frag(in v2f i, out float4 outColor : SV_Target0)
{

#if USE_PLS_DEFERRED
  outColor = GLFramebufferFetch0();
#else
  outColor = float4(1.0, 1.0, 1.0, 1.0);
#endif

}

ENDCG

#END






