#include "functions/mlaa.function"

#SHADER_DEFINE EdgeDetectionVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_pos" },
	}

#SHADER_CODE
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_pos = in_Position.xy;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE







#SHADER_DEFINE EdgeDetectionFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"texture" },
    { PIXEL_SIZE,		HIGH,	VEC2,		"in_pixelSize"},
    
	}
  
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}
  
#SHADER_CODE


  vec3 weights = vec3(0.2126,0.7152, 0.0722);
  vec2 texcoord = textureCoordinate;
  vec2 steppixel =vec2(1.0/544.0,1.0/960.0);
  steppixel = in_pixelSize;
  float yInvese = -1.0;
  float L = dot((texture2D(texture,texcoord).rgb), weights);
  float Lleft = dot((texture2D(texture,texcoord-vec2(1.0,0.0)*steppixel).rgb), weights);
  float Ltop = dot((texture2D(texture,texcoord-vec2(0.0,1.0)*steppixel*yInvese).rgb), weights);
  float Lright = dot((texture2D(texture,texcoord+vec2(1.0,0.0)*steppixel).rgb), weights);
  float Lbottom = dot((texture2D(texture,texcoord+vec2(0.0,1.0)*steppixel*yInvese).rgb), weights);
  float threshold =0.1;
  vec4 delta = abs(sqrt(vec4(L)) - sqrt(vec4(Lleft, Ltop, Lright, Lbottom)));
  vec4 edges = step(vec4(threshold), delta);
  edges.b=0.0;
  vec4 out_SurfaceColor = edges;

#END_CODE
#END_DEFINE



#SHADER_DEFINE SimpleFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"texture" },
	}
  
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}
  
#SHADER_CODE

   vec4 out_SurfaceColor =  texture2D(texture,textureCoordinate).rgba;

#END_CODE
#END_DEFINE


#SHADER_DEFINE SimpleFragmentGamma

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"texture" },
	}
  
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}
  
#SHADER_CODE
   vec4 out_SurfaceColor =  decodegamma(texture2D(texture,textureCoordinate).rgba);
#END_CODE
#END_DEFINE