#include "functions/mlaa.function"

#SHADER_DEFINE BlendWeightVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},

	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
    { ATTRIBUTE_COORDNATE1,			HIGH,	VEC2,		"out_pos" },
	}

#SHADER_CODE
    vec2 out_TexCooridate = in_TexCooridate.xy;
    vec2 out_pos = in_Position.xy;
    gl_Position = in_Position;
#END_CODE
#END_DEFINE




#SHADER_DEFINE BlendWeightFragment

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"textureCoordinate"},
    { TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"texture" },
    { TEXTURE_DIFFUSE_POINT,		NONE,	TEXTURE2D,		"texturePoint" },
    { TEXTURE_AREAMAP,		NONE,	TEXTURE2D,		"textureArea" },
        { PIXEL_SIZE,		HIGH,	VEC2,		"in_pixelSize"},
  
	}
  
  FUNCTION_OUTPUT = 
	{
		{ SURFACE_COLOR,		LOW,	VEC4,		"out_SurfaceColor" },
	}
  
#SHADER_CODE



  vec4 out_SurfaceColor = vec4(0.0,0.0,0.0,1.0);
  vec4 weights = vec4(0.0,0.0,0.0,0.0);
  vec2 e = texture2D(texturePoint,textureCoordinate).rg;
  vec2 texcoord = textureCoordinate;
  vec2 PIXEL_SIZE = vec2(1.0/544.0,1.0/960.0);
  PIXEL_SIZE = in_pixelSize;
  int searchSteps = int(mlaa_searchsteps);
  float NUM_DISTANCES = 32.0;
  float yInverse = -1.0;
  
  if(e.g>0.9)
  {
   vec2 d = vec2(SearchXLeft(textureCoordinate,texture,PIXEL_SIZE,searchSteps), SearchXRight(textureCoordinate,texture,PIXEL_SIZE,searchSteps));
   vec4 coords = vec4(d.x, -0.25*yInverse, d.y + 1.0, -0.25*yInverse)*vec4(PIXEL_SIZE.xy,PIXEL_SIZE.xy)+vec4(texcoord.xy,texcoord.xy);
   float e1 = texture2D(texture,coords.xy).r;
   float e2 = texture2D(texture,coords.zw).r;
   weights.rg = Area(abs(d), e1, e2,NUM_DISTANCES,textureArea);
   
  }



    if (e.r>0.9)
    {
        vec2 d = vec2(SearchYUp2(textureCoordinate,texture,PIXEL_SIZE,searchSteps), SearchYDown2(textureCoordinate,texture,PIXEL_SIZE,searchSteps));
           //vec2 d = vec2(SearchYDown(textureCoordinate,texture,PIXEL_SIZE,searchSteps), SearchYUp(textureCoordinate,texture,PIXEL_SIZE,searchSteps));
        vec4 coords = vec4(-0.25, d.x*yInverse, -0.25, (d.y + 1.0)*yInverse)*vec4(PIXEL_SIZE.xy,PIXEL_SIZE.xy)+vec4(texcoord.xy,texcoord.xy);
        
      float e1 = texture2D(texture,coords.xy).g;
      float e2 = texture2D(texture,coords.zw).g;
      weights.ba = Area(abs(d), e1, e2,NUM_DISTANCES,textureArea);

    }

    out_SurfaceColor = vec4(weights.rg,weights.ba);
   


#END_CODE
#END_DEFINE