

#DEFPARAMS
ALPHA_FACTOR = { "Alpha Factor", FLOAT, "1.0" },
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "Lut"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"
#include "utils.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
Texture2D LOOKUPTABLE;
SamplerState TEXTURE_DIFFUSE_Sampler;
SamplerState LOOKUPTABLE_Sampler;
float ALPHA_FACTOR;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#ifdef POST_EFFECT_ALPHA_OFF
		float3 rgb3 = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).rgb;
		float4 rgb4 = float4(rgb3, 1.0);
		mainColor = LUT(rgb4, LOOKUPTABLE, LOOKUPTABLE_Sampler);
	#elif POST_EFFECT_ALPHA_ON
		float4 rgba = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
		float4 lrgba = LUT(rgba,LOOKUPTABLE, LOOKUPTABLE_Sampler);
		mainColor = float4(lrgba.rgb * ALPHA_FACTOR + rgba.rgb * (1.0 - ALPHA_FACTOR),rgba.a);

	#endif
}
ENDCG
#END
