

#DEFPARAMS
[Keywords(POST_EFFECT_ALPHA_ON, POST_EFFECT_ALPHA_OFF)]
POST_EFFECT_ALPHA = {"post_effect_alpha", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName = "Identity"
RenderQueue = "PostEffect"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile POST_EFFECT_ALPHA_ON POST_EFFECT_ALPHA_OFF
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_Sampler;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv.xy;

	return o;
}

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
	#ifdef POST_EFFECT_ALPHA_OFF
		float3 color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv).rgb;
		mainColor = float4(color, 1.0f);
	#elif POST_EFFECT_ALPHA_ON
		float4 color = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_Sampler, i.uv);
		mainColor = color;
	#endif
}
ENDCG
#END
