#DEFPARAMS
#END

#DEFTAG
ShaderName = "hair_clear_copy"
RenderQueue = "Transparent"
#END

#DEFPASS Hair_Clear_Copy
COLOR_MASK   = COLOR_NONE
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = { STENCIL_OFF }
LIGHT_MODE   = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"


struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

RWTexture2D<uint> HAIR_FIRSTLAYER_DEPTH : register(u1);
RWTexture2D<uint> HAIR_SECONDLAYER_DEPTH : register(u2);
RWTexture2D<uint> HAIR_THIRDLAYER_DEPTH : register(u3);


Texture2D TEXTURE_SCENE_DEPTH;
SamplerState TEXTURE_SCENE_DEPTH_SAMPLER;

v2f vert(appdata v)
{
    v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}


void frag(in v2f v, out float depth : SV_Depth)
{
    int2 vScreenAddress = int2(v.vertex.xy);

    uint clearDepth = asuint(1.0);

    HAIR_FIRSTLAYER_DEPTH[uint2(vScreenAddress)] = clearDepth;
    HAIR_SECONDLAYER_DEPTH[uint2(vScreenAddress)] = clearDepth;
    HAIR_THIRDLAYER_DEPTH[uint2(vScreenAddress)] = clearDepth;

    float sceneDepth = TEXTURE_SCENE_DEPTH.Sample(TEXTURE_SCENE_DEPTH_SAMPLER, v.uv).r;
    depth = sceneDepth;
}
ENDCG
#END
