#include"functions/geotrans.function"
#SHADER_DEFINE FourImgVertex

	FUNCTION_INPUT = 
	{
		{ ATTRIBUTE_POSITION, 			HIGH,	VEC4,		"in_Position" },
		{ ATTRIBUTE_COORDNATE0, 		HIGH,	VEC2,		"in_TexCooridate"},
   
	}
	FUNCTION_OUTPUT =
	{
		{ ATTRIBUTE_COORDNATE0,			HIGH,	VEC2,		"out_TexCooridate" },
	}

#SHADER_CODE
    gl_Position = in_Position;
    vec2 out_TexCooridate = in_TexCooridate.xy;
    
#END_CODE
#END_DEFINE

#SHADER_DEFINE FourImgFragment

	FUNCTION_INPUT = 
	{
		{ TEXTURE_DIFFUSE,		NONE,	TEXTURE2D,		"uniCurrentTexture" },
		{ ATTRIBUTE_COORDNATE0,		HIGH,	VEC2,		"in_TexCooridate"},
		{ RATIOASPECT,    MEDIUM,    FLOAT,        "aspectRatio"},

	}
  
#SHADER_CODE
  
   
   if(abs(in_TexCooridate.y-0.5)>0.5/aspectRatio){
      gl_FragColor = vec4(vec3(0.0),1.0);
   }
   else{
	   vec2 center = vec2(0.5,0.5);
	   const float pi = 3.1415926;
	   vec2 in_TexCooridate2 = vec2(in_TexCooridate.x,in_TexCooridate.y);
	   
	   float angle =  getangle(in_TexCooridate2,center,aspectRatio);
	   vec2 Coord = vec2(0.0);
	   if(-pi <= angle && angle < -1.0/2.0*pi)
	   {  
	      in_TexCooridate2 = 1.3*in_TexCooridate2;
	      Coord = rotate(in_TexCooridate2-center,1.0*pi/4.0,aspectRatio)+center; 
	   }
	   else if(-1.0/2.0*pi <= angle && angle < 0.0)
	   {  
	      in_TexCooridate2 = rotate(in_TexCooridate2-center,-1.0*pi/2.0,aspectRatio)+center;
	      in_TexCooridate2 = 1.3*in_TexCooridate2;
	      Coord = rotate(in_TexCooridate2-center,1.0*pi/4.0,aspectRatio)+center;
	   }
	   else if(0.0 <= angle && angle < 1.0/2.0*pi)
	   {  
	      in_TexCooridate2 = rotate(in_TexCooridate2-center,pi,aspectRatio)+center;
	      in_TexCooridate2 = 1.3*in_TexCooridate2;
	      Coord = rotate(in_TexCooridate2-center,1.0*pi/4.0,aspectRatio)+center;
	   }
	   else if(1.0/2.0*pi <= angle && angle < pi)
	   {  
	      in_TexCooridate2 = rotate(in_TexCooridate2-center,1.0*pi/2.0,aspectRatio)+center;
	      in_TexCooridate2 = 1.3*in_TexCooridate2;
	      Coord = rotate(in_TexCooridate2-center,1.0*pi/4.0,aspectRatio)+center;
	   }
       vec3 color = texture2D(uniCurrentTexture,Coord).rgb;
       gl_FragColor = vec4(color,1.0);
   }
 

#END_CODE
#END_DEFINE
   