#DEFPARAMS
TEXTURE_DIFFUSE = { "main Color", TEXTURE2D, "white" }
#END

#DEFTAG
ShaderName = "unlit_instance"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_ON, DEPTH_TEST_ON, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#pragma multi_compile_skin
#pragma multi_compile_gpuinstacing
#include "light.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
	ANI_ATTRIBUTE
	VERTEX_INPUT_INSTANCE_ID
};

struct v2f
{
	float2 uv : TEXCOORD0;
	float4 vertex : SV_POSITION;
};

struct BoneMatrix
{
    float4 pose0;
	float4 pose1;
	float4 pose2;
};
StructuredBuffer<BoneMatrix> _BoneMatrixArray;
//ByteAddressBuffer _FrameID;
float _BoneCount;

float3 Skinning(float4 pos, float offset, float4 boneInd, float4 weight)
{
    float3 vert = float3(0.0, 0.0, 0.0);

    [loop]
    for (uint i = 0; i < 4; ++i)
    {
		int idx = int(offset+boneInd[i]);
    	float4 row0 = _BoneMatrixArray[idx].pose0;
    	float4 row1 = _BoneMatrixArray[idx].pose1;
    	float4 row2 = _BoneMatrixArray[idx].pose2;
    
		float4x4 m = float4x4(row0.x, row1.x, row2.x, 0.0,
								row0.y, row1.y, row2.y, 0.0,
								row0.z, row1.z, row2.z, 0.0,
								row0.w, row1.w, row2.w, 1.0);
		vert += mul(pos, m).xyz * weight[i];
    }
    return vert;
}

Texture2D TEXTURE_DIFFUSE;
SamplerState TEXTURE_DIFFUSE_SAMPLER;

v2f vert(appdata v)
{
	float4 initPos = v.vertex;
	//COMPUTE_BONE_MATERIX(v)
#if GPUINSTANCING && GPUSKIN4
	SETUP_INSTANCE_ID(v);
	uint instID = GET_INSTANCE_ID(v);
	//float frameID = asfloat(_FrameID.Load(instID));
	float3 tPos = Skinning(v.vertex, _BoneCount*FrameIdx, v.boneIndices, v.boneWeight);
	initPos.xyz = tPos;
	BONE_TRANSFROM = float4x4(1.0,0.0,0.0,0.0,
							  0.0,1.0,0.0,0.0,
							  0.0,0.0,1.0,0.0,
							  0.0,0.0,0.0,1.0);
#endif
  	v2f o;
	float4 pos = ObjectToClipPos(initPos);
	o.vertex = UniformNDC(pos);
	o.uv = v.uv.xy;
	return o;
}

void frag(in v2f i, out float4 outColor : SV_Target0)
{
	// sample the texture
	outColor = TEXTURE_DIFFUSE.Sample(TEXTURE_DIFFUSE_SAMPLER, i.uv);
}
ENDCG
#END
