CGPROGRAM

#include "hair_common.inc"


#pragma compute CalculateStrandLevelData

[numthreads(THREAD_GROUP_SIZE,1,1)]
void CalculateStrandLevelData(
    uint GIndex : SV_GroupIndex,
    uint3 GId : SV_GroupID,
    uint3 DTid : SV_DispatchThreadID)
{
   
    uint local_id, group_id, globalStrandIndex, numVerticesInTheStrand, globalRootVertexIndex;
    CalcIndicesInStrandLevelMaster(GIndex, GId.x, globalStrandIndex, numVerticesInTheStrand, globalRootVertexIndex);

    float4 pos_old_old[2]; // previous previous positions for vertex 0 (root) and vertex 1.
    float4 pos_old[2]; // previous positions for vertex 0 (root) and vertex 1.
    float4 pos_new[2]; // current positions for vertex 0 (root) and vertex 1.

    pos_old_old[0] = g_HairVertexPositionsPrevPrev[globalRootVertexIndex];
    pos_old_old[1] = g_HairVertexPositionsPrevPrev[globalRootVertexIndex + 1];

    pos_old[0] = g_HairVertexPositionsPrev[globalRootVertexIndex];
    pos_old[1] = g_HairVertexPositionsPrev[globalRootVertexIndex + 1];
    
    pos_new[0] = g_HairVertexPositions[globalRootVertexIndex];
    pos_new[1] = g_HairVertexPositions[globalRootVertexIndex + 1];

    float3 u = normalize(pos_old[1].xyz - pos_old[0].xyz);
    float3 v = normalize(pos_new[1].xyz - pos_new[0].xyz);

    // Compute rotation and translation which transform pos_old to pos_new. 
    // Since the first two vertices are immovable, we can assume that there is no scaling during tranform. 
    float4 rot = QuatFromTwoUnitVectors(u, v);
    float3 trans = pos_new[0].xyz - MultQuaternionAndVector(rot, pos_old[0].xyz);

    float vspCoeff = GetVelocityShockPropogation();
    float restLength0 = g_HairRestLength[globalRootVertexIndex];
    float vspAccelThreshold  = GetVSPAccelThreshold();

    // Increate the VSP coefficient by checking pseudo-acceleration to handle over-stretching when the character moves very fast 
    float accel = length(pos_new[1] - 2.0 * pos_old[1] + pos_old_old[1]);

    if (accel > vspAccelThreshold) // TODO: expose this value?
        vspCoeff = 1.0f;
    g_StrandLevelData[globalStrandIndex].vspQuat = rot;
    g_StrandLevelData[globalStrandIndex].vspTranslation = float4(trans, vspCoeff);  //vspCoeff

    // skinning

    // Copy data into shared memory
    float4 initialPos = g_InitialHairPositions[globalRootVertexIndex]; // rest position

}


ENDCG