CGPROGRAM

#define NUM_THREADS 8
#include "fluid_simulation.inc"

float _Radius, _DeltaTime;
float2 _AmountD;
float3 _Pos;

RWStructuredBuffer<float2> _WriteD;
// RWStructuredBuffer<float> _WriteT;

#pragma compute GaussImpulse

[numthreads(NUM_THREADS,NUM_THREADS,NUM_THREADS)]
void GaussImpulse(int3 id : SV_DispatchThreadID)
{
 	int idx = dot(id, float3(1, _Size.xw));
	
	float3 wpos = GridCord2WorldPos(float3(id));
	float d = distance(_Pos, wpos);

	float impulse = 0;

	if(d < _Radius) 
	{
		float a = (_Radius - d) * 0.5;
		impulse = min(a, 1.0);
	} 
	
	_WriteD[idx] = max(float2(0,0), lerp(_WriteD[idx], _AmountD, float2(impulse, impulse)));
	// _WriteT[idx] = max(0, lerp(_WriteT[idx], _AmountT, impulse));
	
}

ENDCG

