// This code contains NVIDIA Confidential Information and is disclosed to you
// under a form of NVIDIA software license agreement provided separately to you.
//
// Notice
// NVIDIA Corporation and its licensors retain all intellectual property and
// proprietary rights in and to this software and related documentation and
// any modifications thereto. Any use, reproduction, disclosure, or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA Corporation is strictly prohibited.
//
// ALL NVIDIA DESIGN SPECIFICATIONS, CODE ARE PROVIDED "AS IS.". NVIDIA MAKES
// NO WARRANTIES, EXPRESSED, IMPLIED, STATUTORY, OR OTHERWISE WITH RESPECT TO
// THE MATERIALS, AND EXPRESSLY DISCLAIMS ALL IMPLIED WARRANTIES OF NONINFRINGEMENT,
// MERCHANTABILITY, AND FITNESS FOR A PARTICULAR PURPOSE.
//
// Information and code furnished is believed to be accurate and reliable.
// However, NVIDIA Corporation assumes no responsibility for the consequences of use of such
// information or for any infringement of patents or other rights of third parties that may
// result from its use. No license is granted by implication or otherwise under any patent
// or patent rights of NVIDIA Corporation. Details are subject to change without notice.
// This code supersedes and replaces all information previously supplied.
// NVIDIA Corporation products are not authorized for use as critical
// components in life support devices or systems without express written approval of
// NVIDIA Corporation.
//
// Copyright (c) 2008-2020 NVIDIA Corporation. All rights reserved.
// Copyright (c) 2004-2008 AGEIA Technologies, Inc. All rights reserved.
// Copyright (c) 2001-2004 NovodeX AG. All rights reserved.

#ifdef __cplusplus
#pragma once

#include <foundation/Px.h>
#include "Simd.h"

namespace nv
{
	namespace cloth
	{

		class DxCloth;
		template <typename>
		struct IterationState;
#else  // __cplusplus
#endif

static const uint MaxParticlesInSharedMem = 1969;


struct DxPhaseConfig
{
	float mStiffness;
	float mStiffnessMultiplier;
	float mCompressionLimit;
	float mStretchLimit;

	uint mFirstConstraint;
	uint mNumConstraints;
};

struct DxConstraint
{
	float mRestvalue;
#ifdef __cplusplus
	uint16_t mFirstIndex;
	uint16_t mSecondIndex;
#else
	uint mIndices; // 2x uint16_t
#endif
};

struct DxTether
{
#ifdef __cplusplus
	DxTether(uint16_t, uint16_t);
	uint16_t mAnchor;
	uint16_t mLength;
#else
	uint mValue;   // 2x uint16_t
#endif
};

// reference to cloth instance bulk data (POD)
// should not need frequent updates (stored on device)
struct DxClothData
{
#ifdef __cplusplus
	DxClothData()
	{
	}
	DxClothData(DxCloth&);
#endif

	uint mNumParticles;
	uint mParticlesOffset;

	// fabric constraints
	uint mNumPhases;
	uint mPhaseConfigOffset;
	uint mConstraintOffset;
	uint mStiffnessOffset; //Offset inside per constraint stiffness buffer

	uint mNumTethers;
	uint mTetherOffset;
	float mTetherConstraintScale;

	uint mNumTriangles;
	uint mStartTriangleOffset;

	// motion constraint data
	float mMotionConstraintScale;
	float mMotionConstraintBias;

	// collision
	uint mNumCapsules;
	uint mCapsuleOffset;
	uint mNumSpheres;

	uint mNumPlanes;
	uint mNumConvexes;
	uint mConvexMasksOffset;

	uint mNumCollisionTriangles;

	uint mNumVirtualParticleSetSizes;

	uint mEnableContinuousCollision; //bool stored in uint for dx alignment
	float mCollisionMassScale;
	float mFrictionScale;

	float mSelfCollisionDistance;

	uint mNumSelfCollisionIndices;
	uint mSelfCollisionIndicesOffset;
	uint mSelfCollisionParticlesOffset;
	uint mSelfCollisionDataOffset;

	// sleep data
	uint mSleepTestInterval;
	uint mSleepAfterCount;
	float mSleepThreshold;
};

// per-frame data (stored in pinned memory)
struct DxFrameData
{
#ifdef __cplusplus
	DxFrameData()
	{
	} // not initializing pointers to 0!

	explicit DxFrameData(DxCloth&, uint numSharedPositions, const IterationState<Simd4f>&, uint firstIteration);
#endif

	bool mDeviceParticlesDirty;

	// number of particle copies that fit in shared memory (0, 1, or 2)
	uint mNumSharedPositions;

	// iteration data
	float mIterDt;
	uint mFirstIteration;
	uint mNumIterations;

	float mTetherConstraintStiffness;

	// wind data
	float mDragCoefficient;
	float mLiftCoefficient;
	float mFluidDensity;
	float mRotation[9];

	// motion constraint data
	float mMotionConstraintStiffness;
	uint mStartMotionConstrainsOffset;
	uint mTargetMotionConstrainsOffset;

	// separation constraint data
	uint mStartSeparationConstrainsOffset;
	uint mTargetSeparationConstrainsOffset;

	// particle acceleration data
	uint mParticleAccelerationsOffset;

	uint mStartSphereOffset;
	uint mTargetSphereOffset;

	uint mStartCollisionPlaneOffset;
	uint mTargetCollisionPlaneOffset;

	uint mStartCollisionTrianglesOffset;
	uint mTargetCollisionTrianglesOffset;

	float mSelfCollisionStiffness;

	float mParticleBounds[6]; // maxX, -minX, maxY, ...

	uint mSleepPassCounter;
	uint mSleepTestCounter;

	float mStiffnessExponent;

	uint mRestPositionsOffset;

	bool mInitSelfCollisionData;
};

// per-iteration data (stored in pinned memory)
struct DxIterationData
{
#ifdef __cplusplus
	DxIterationData()
	{
	} // not initializing!
	explicit DxIterationData(const IterationState<Simd4f>&);
#endif
	float mIntegrationTrafo[24];
	float mWind[3];
	uint mIsTurning;
};

#ifdef __cplusplus
	} // namespace cloth
} // namespace nv
#endif
