#DEFPARAMS

#END

#DEFTAG
ShaderName = "rwtexture"
RenderQueue = "Opaque"
#END

#DEFPASS Always
COLOR_MASK = COLOR_RGBA
ALPAH_MODE = { ALPAH_OFF }
DRAW_MODE = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}
LIGHT_MODE = { ALWAYS }

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
	float4 vertex : POSITION;
	float2 uv : TEXCOORD0;
};

struct v2f
{
	float4 vertex : SV_POSITION;
	float2 uv : TEXCOORD0;
};

RWTexture2D<uint> curWTex;

v2f vert(appdata v)
{
	v2f o;
	o.vertex = UniformNDC(v.vertex);
	o.uv = v.uv;
	return o;
}

void frag(v2f i, out float4 mainColor:SV_Target0)
{
	uint uDepth = (uint)(i.vertex.z * 1000.0);
	uint uDepth0Prev, uDepth1Prev;

	int2 vScreenAddress = int2(i.vertex.xy);
    // Min of depth 0 and input depth
    // Original value is uDepth0Prev
    curWTex[uint2(vScreenAddress)] = 500;
	//InterlockedMin(curWTex1[uint2(vScreenAddress)], 0.6f, uDepth0Prev);
    float preDepth = (float)uDepth / 1000.0f;
	mainColor = float4(preDepth, preDepth, preDepth, 1.0);
}
ENDCG
#END



