local SequenceAnimation = require "apolloutility.sequenceanimation"
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local Faceinfo = require "videodecet.faceinfo";
local Actioninfo = require "videodecet.actioninfo";
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local likeapp = require "likeapp"
local faceseg = require "videodecet.faceseg"



local maxfacecount = 3;
local keypointcount = 106;
local testvidesize = {720, 1280}

local videodecet = {}
setmetatable(videodecet, basedetect);

function videodecet:Initialize(imagedoc, imagefile, pointfile)

  self.isShowDebugPoint = true ;

  --新帧回调
  self.newframecallback = {}
  setmetatable(self.newframecallback, {__mode = "v"})

  apolloengine.ShaderEntity.POINT_COLOR = 
    apolloengine.IMaterialSystem:NewParameterSlot(
      apolloengine.ShaderEntity.UNIFORM,
      "POINT_COLOR");
    
  self.animation = SequenceAnimation(defiend.blit_material_path);
  --self.animation:SetShow(false);
  renderqueue:Prev(self.animation)

  self.animation:Play(imagedoc, imagefile, nil, 30, true, 1,true); --修改为keepsource,以可以向faceseg传递texturestream(方便瞳孔识别测试)
  --self.animation:Play(imagedoc, imagefile, nil, 30, true, 1, false); --保留原始数据我增加内存开销

  --创建解析服务
  self.paserservice = venuscore.IServicesSystem:Create("videodecet.paserservice_action");

  self.bodypoints = {}
  self.pointrenders = {}
  local keypointcount = self.paserservice:GetKeyPointCount();
  
  for i=1, maxfacecount do
    local pr = apollonode.PointNode();
    pr:CreateResource(
      keypointcount,
      mathfunction.vector4(0,1,0,1),
      "comm:documents/material/pointrender.material");
    pr:SetShow(false);
    renderqueue:Prev(pr);
    table.insert(self.pointrenders, pr);
  end
  
  --动作信息
  self.actioninfos = {}
  
  --解析关键点
  self.frameindex = 0;
  self.faceframes = {}
  self.insertfunction = function (fdatas, adatas)
    local faces = {};
    for _, d in ipairs(fdatas) do
      local fi = Faceinfo:cast(d);
      table.insert(faces, fi);
    end    
    table.insert(self.faceframes, faces);
    --动作
    local pepole = {};--camera和android每个人可能有多个动作，这里模拟一下
    local actions = {};
    table.insert(pepole, actions);
    for _, d in ipairs(adatas) do
      local ai = Actioninfo:cast(d);
      table.insert(actions, ai);
    end    
    table.insert(self.actioninfos, pepole);    
    return true;
  end
  local agent, index = g_callbackhandle:RegisterCallback(self.insertfunction);
  local fullpath = venuscore.IFileSystem:PathAssembly(imagedoc..pointfile);
  self.paserservice:PaserFile(agent, index, testvidesize, fullpath);  
end

function videodecet:ShowKeypoint(isshow)
  
end

function videodecet:AddNewframeCallback(func)
  table.insert(self.newframecallback, func);
end

function videodecet:RemoveNewframeCallback(func)
  local len = #self.newframecallback
  for i = 1, len do
    if func == self.newframecallback[i] then
      table.remove(self.newframecallback, i)
    end
  end
end

function videodecet:Update(def)
  local _, frame = self.animation:Update(def);
  if self.frameindex ~= frame then
    self.frameindex = frame;
    local faces = self.faceframes[frame];
    if faces  and self.isShowDebugPoint  then
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        local fi = faces[i];
        if fi then
          pr:SetShow(true);
          pr:Update(fi:GetKeypointArray());
        else
          pr:SetShow(false);
        end
      end
    else
      for i=1, #self.pointrenders do
        local pr = self.pointrenders[i];
        pr:SetShow(false);
      end
    end
    for _, func in ipairs(self.newframecallback) do
      func();
    end
    local texturergb, texturealpha = self.animation:GetCurrentTexture();
    local texsize = texturergb:GetSize();
    self.size = {texsize:x(), texsize:y()};
    local ts = texturergb:GetSourceStream();
    faceseg:Initialize(self.size[1], self.size[2]);
    faceseg:Update(ts,def);

    apolloengine.DeviceResource:PushDeviceResource(
      apolloengine.DeviceResource.DEVICE_CAPTURE,
      texturergb
    );
    return true;
  end
  --得到ts,做分割
  local texturergb, texturealpha = self.animation:GetCurrentTexture()
  local texsize = texturergb:GetSize();
  self.size = {texsize:x(), texsize:y()};
  local ts = texturergb:GetSourceStream();
  faceseg:Initialize(self.size[1], self.size[2]);
  faceseg:Update(ts,def);

  apolloengine.DeviceResource:PushDeviceResource(
    apolloengine.DeviceResource.DEVICE_CAPTURE,
    texturergb
  );

  return false;
end

function videodecet:SetTexture(tex)
end

--得到当前的人脸信息
function videodecet:GetFaces()
  return self.faceframes[self.frameindex];
end

function videodecet:GetPixelFacekeypointArray()
  local keypointarray = mathfunction.vector2array();
  local faces = self.faceframes[self.frameindex];
  
  for i = 1,#faces do
    local fi = faces[i];
    if fi then
      local facillandmark = fi:GetPixelKeypointArray();
      local cnt = #facillandmark;
      for i = 1,#facillandmark do
        local point = mathfunction.vector2(facillandmark[i][1],facillandmark[i][2]);
        keypointarray:PushBack(point);
      end
    end
  end
  
  return keypointarray;
end


function videodecet:UpdateKeypoints(idx,keypoint)
  self.faceframes[self.frameindex][idx]:UpdateKeypoints(keypoint);
end

--加载玩素材之后 根据素材的配置 启动相关检测
function videodecet:launchDetectFlag()

end

function videodecet:resetDetectFlag()
  -- 暂时没有需要
end

function videodecet:GetActions()
  return self.actioninfos[self.frameindex];
end

function videodecet:ActiveActions(actions)
  likeapp.AI:ActiveActions(actions)
end

function videodecet:GetBodyPoints()
  return self.bodypoints;
end

--得到当前的视屏纹理
function videodecet:GetVideoTexture()
  return self.animation:GetCurrentTexture();
end

function videodecet:SetShow(isShow)
  self.animation:SetShow(isShow);
end

function videodecet:SetDebugPointShow(isShow)
  self.isShowDebugPoint = isShow ;
end

function videodecet:PushNewFaceLandMark()
  local newFaceLandMarks = {};
  local index = 1 ;
  local faces = self:GetFaces();
  for _, face in pairs(faces) do
    local keypointArray = face:GetKeypointArray();
    for _, one in pairs(keypointArray) do
      local x, y = face:toAbsoluteCoordinates(one);
      newFaceLandMarks[index]   = x;
      newFaceLandMarks[index+1] = y;
      index = index + 2 ;
    end
  end
  likeapp.AI:PushNewFaceLandMark(newFaceLandMarks);
end

function videodecet:GetExtrapoints()
  return nil;
end


function videodecet:GetVideoSize()
  return self.size;
end

function videodecet:GetVideoFrame()
  return self.animation:GetCurrentTexture():GetSourceStream()
end

function videodecet:GetVideoFrameRGB()
  local rgb,_ =self.animation:GetCurrentTexture();
  return rgb:GetSourceStream();
end

function videodecet:SetBodyPoints()
  
end

return videodecet;
