local SequenceAnimation = require "apolloutility.sequenceanimation"
local apollonode = require "apolloutility.apollonode"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"


local windows_video_cutter = {}

function windows_video_cutter:Initialize(camera, imagedoc, imagefile, pointfile)
  self.animation = SequenceAnimation(defiend.blit_material_path);
  self.animation:SetSequence(camera:GetSequence());
  self.animation:Play(imagedoc, imagefile, nil, 30, true, 1, true);
end

function windows_video_cutter:Update(def)
  local _, frame = self.animation:Update(def);  
  local texturergb, texturealpha = self.animation:GetCurrentTexture();
  apolloengine.DeviceResource:PushDeviceResource(
      apolloengine.DeviceResource.DEVICE_CAPTURE,
      texturergb);
  apolloengine.DeviceResource:PushDeviceResource(
      defiend.LAST_QUEUE_TEXTURE,
      texturergb);    
  return true;
end

--得到当前的视屏纹理
function windows_video_cutter:GetVideoTexture()
  return self.animation:GetCurrentTexture();
end

function windows_video_cutter:SetTexture(size, texid)  
  ERROR("windows platform: "..size[1].." h: "..size[2]);
end

return windows_video_cutter;