local SequenceAnimation = require "apolloutility.sequenceanimation"
local ImageService = require "apolloutility.texturereader"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local stringsplit = require "stringsplit"
local venuscore = require "venuscore"
local Object = require "classic"



local squareinfo = Object:extend();

squareinfo.split_w = 8;
squareinfo.split_h = 8;

function squareinfo:new(size)
  self.global_width = size[1];
  self.global_height = size[2];
  self.square = {};
  self.vertexArray = {};
  self.texcoordArray = {};
end

function squareinfo:ToRelativeCoordinates(pixel_x, pixel_y)
  return pixel_x / self.global_width * 2 - 1, 1 - pixel_y / self.global_height * 2;
end

function squareinfo:ToPixelCoordinates(screen_x,screen_y)
  local pixel_x = ((screen_x + 1) / 2) * self.global_width;
  local pixel_y = ((1 - screen_y) / 2) * self.global_height;
end

function squareinfo:SetID(id)
  self.id = id;
end

function squareinfo:GetID()
  return self.id;
end

function squareinfo:PushSquare(pixelX_1,pixelY_1,pixelX_2,pixelY_2,pixelX_3,pixelY_3,pixelX_4,pixelY_4)
  local sx1,sy1 = self:ToRelativeCoordinates(pixelX_1,pixelY_1);
  local sx2,sy2 = self:ToRelativeCoordinates(pixelX_2,pixelY_2);
  local sx3,sy3 = self:ToRelativeCoordinates(pixelX_3,pixelY_3);
  local sx4,sy4 = self:ToRelativeCoordinates(pixelX_4,pixelY_4);
  table.insert(self.square,{sx1,sy1});
  table.insert(self.square,{sx2,sy2});
  table.insert(self.square,{sx3,sy3});
  table.insert(self.square,{sx4,sy4});

  self:Tesslate();
end

function squareinfo:GetRectPixelWidth()
  return self.global_width;
end

function squareinfo:GetRectPixelHeight()
  return self.global_height;
end


function squareinfo:GetSquare()
  return self.square;
end

function squareinfo:Tesslate()

  local p1 = self.square[1];
  local p2 = self.square[2];
  local p3 = self.square[3];
  local p4 = self.square[4];

  --tesslate
  local vectorLeftEdge = { (p3[1] - p1[1]), (p3[2] - p1[2]) };
  local vectorRightEdge = { (p4[1] - p2[1]), (p4[2] - p2[2]) };
  for i = 0, squareinfo.split_h do
	local pointLeft = { (p1[1] + (i / squareinfo.split_h) * vectorLeftEdge[1]), (p1[2] + (i / squareinfo.split_h) * vectorLeftEdge[2]) };
	local pointRight = { (p2[1] + (i / squareinfo.split_h) * vectorRightEdge[1]), (p2[2] + (i / squareinfo.split_h) * vectorRightEdge[2]) };
    for j = 0, squareinfo.split_w do
      local vectorX = { (pointRight[1] - pointLeft[1]), (pointRight[2] - pointLeft[2]) };
      local point = { (pointLeft[1] + (j / squareinfo.split_w) * vectorX[1]), (pointLeft[2] + (j / squareinfo.split_w) * vectorX[2]) };
      local texcoord = { j / squareinfo.split_w, i / squareinfo.split_h };
      --分割信息
      table.insert(self.vertexArray,point);
      table.insert(self.texcoordArray,texcoord);
    end
  end
end

function squareinfo:GetTesslateData()
    return self.vertexArray,self.texcoordArray;
end



return squareinfo;