
local basedetect = require "videodecet.basevideodetect";
local apollonode = require "apolloutility.apollonode"
local renderqueue = require "apolloutility.renderqueue"
local defiend = require "apolloutility.defiend"
local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local LyricSequenceBase = require "photomood.lyric_sequence_base"
local venuscore = require "venuscore"
local videodecet = require "videodecet"
local biugodefined = require "photomood.defined"
local CustomeTextureManager = require "photomood.customtexture"
local likeapp = require "likeapp"
local Object = require "classic"



local LyricSequence = LyricSequenceBase:extend();


function LyricSequence:new(inEffect,outEffect,outline_Color,outline_Offset,videowidth,videoheight)
  LyricSequence.super.new(self,inEffect,outEffect,outline_Color,outline_Offset);
  self.video_width = videowidth;
  self.video_height = videoheight;
  self.last_frameIndex = 0;
end



function LyricSequence:Update()
  local frameIndex = likeapp.AI:GetFrameIndex();
  --由帧号计算时间，photomood目前固定帧率20帧
  local timespan = 0.0;
  if frameIndex ~= 0 then
    timespan = (frameIndex - self.last_frameIndex) * (1.0 / 20)
  end
  self.last_frameIndex = frameIndex;
  
  
  LyricSequence.super.Update(self,timespan);
end

function LyricSequence:GetCustomTextureSize()
  --local custom_texture, custom_texture_size = CustomeTextureManager:GetCustomTexture(self.maskID);
  local customTextureSize = mathfunction.vector2(0.0,0.0);
  --local ts = CustomeTextureManager:GetCustomTexture()-- likeapp.AI:GetCustomTexture(1); --按照要求photo mood只会上传一张图片
  local custom_texture, custom_texture_size = CustomeTextureManager:GetCustomTexture(1);
  if custom_texture_size ~= nil then
    customTextureSize = custom_texture_size;
  end
  return customTextureSize;
end

function LyricSequence:CalcScreenPosSize(lyricPosition,lyricSize,customtexture_size)  --适配层说坐标是相对于图片左下角的比例
  
  local vertexScaler = mathfunction.vector2(1.0,1.0);
  if customtexture_size ~= nil then
    local custom_texture_width = customtexture_size:x();
    local custom_texture_height = customtexture_size:y();
    local rect_width = self.video_width;
    local rect_height = self.video_height;
    local rectRatio = rect_width / rect_height;
    local textureRatio = custom_texture_width / custom_texture_height;
    
    if textureRatio > rectRatio then
      vertexScaler:Set(1.0,rectRatio / textureRatio);
    elseif textureRatio < rectRatio then
      vertexScaler:Set(textureRatio / rectRatio,1.0);
    else
      vertexScaler:Set(1.0,1.0);
    end
  end
  
  local posX = lyricPosition:x();
  local posY = lyricPosition:y();
  local sizeX = lyricSize:x();
  local sizeY = lyricSize:y();
  
  local screenPos = { (-1.0 + posX * 2.0) * vertexScaler:x(), (-1.0 + (posY + sizeY) * 2.0) * vertexScaler:y() };
  local screenSize = { sizeX * 2.0 * vertexScaler:x(), sizeY * 2.0 * vertexScaler:y() };
  
  return screenPos, screenSize;
end


function LyricSequence:SetLyric(lyricTextureID,lyricColor,lyricDuration,lyricSize,lyricPosition,isNew)
  if lyricSize and lyricTextureID then
    if isNew == true then
      if self.lyric_texture == nil or self.lyric_texture:GetInternelID() ~= lyricTextureID then
        local tex = apolloengine.TextureEntity();
        tex:PushMetadata(
          apolloengine.TextureResourceMetadata(
            self:GetCustomTextureSize(),lyricTextureID));
        tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
        tex:CreateResource();
        
        self.lyric_texture = tex;
      end
      local screenPos, screenSize = self:CalcScreenPosSize(lyricPosition,lyricSize,self:GetCustomTextureSize());
      self.lyric_location = screenPos;
      self.lyric_texture_size = screenSize;
      self.lyric_show_time = lyricDuration / 1000;
      self.lyric_acc_time = 0.0;
      self.progress_pre = 0.0;
      self.progress_post = 0.0;
    end
    self.lyric_color = {lyricColor:x(),lyricColor:y(),lyricColor:z()};  --适配层说，如果不是新歌词，只更新颜色
    self.lyricrender:SetRenderRect(self.lyric_location,self.lyric_texture_size,self.lyric_color,self.useOriginColor);
    --self:SetShow(true); --开启绘制
  else
    ERROR("empty lyric texture size or texid");
  end
end


return LyricSequence;


