local BundleSystem = require "venuscore.bundle.bundlesystem"
local renderqueue = require "apolloutility.renderqueue"
local apollonode = require "apolloutility.apollonode"
local defined = require "apolloutility.defiend"
local mathfunction = require "mathfunction"
local apolloengine = require "apollocore"
local videodecet = require "videodecet"
local venuscore = require "venuscore"
local venusjson = require "venusjson"
local Object = require "classic"
local apolloDefine = require "apolloutility.defiend"
local BlueDefined = require "bluecore.bluedefined"
local colorspaceconverter = require "colorspaceconverter"

local BaseScene = Object:extend();

function BaseScene:new(sceneSequence,insertLayer)
  self.nativeScene = nil;
  self.scenePath = nil;
  self.sceneSequence = sceneSequence;
  self.insertLayer = insertLayer;
  self.outputCamera = {};  --编辑器素材中没有挂RT的相机
  self.outputLayer = nil;  --需要输出的renderqueue层
  self.gtlConverter = nil;
  self.ltgConverter = nil;
end

function BaseScene:LoadConfig(path)
  local bundlepath = venuscore.IFileSystem:PathAssembly(path);
  local nativeScene = BundleSystem:DeserializeFromPath(bundlepath,BundleSystem.DeserializeMode.Scene);
  if nativeScene then

    if apolloengine.Framework:IsCurrentAdvancedShading() then
      self.gtlConverter = colorspaceconverter.new();
      local viewSize = apolloengine.Framework:GetResolution();
      -- create converter from current scene
      -- gamma to linear
      local isSRGB2Linear = true;
      local LayerMask = "baseSceneGTL";
      self.gtlConverter:Initialize_sRGB_Transfer(nativeScene, isSRGB2Linear, mathfunction.vector2(viewSize:x(), viewSize:y()), LayerMask);
      self.gtlConverter:Activate();

      -- linear to gamma
      isSRGB2Linear = false;
      LayerMask = "baseSceneLTG";
      self.ltgConverter = colorspaceconverter.new();
      self.ltgConverter:Initialize_sRGB_Transfer(nativeScene, isSRGB2Linear, mathfunction.vector2(viewSize:x(), viewSize:y()), LayerMask);
      self.ltgConverter:Activate();
    end

    self:_Setup(nativeScene);
    self.nativeScene = nativeScene;
    self.scenePath = bundlepath;

    --素材加载完之后再Active
    local sceneRoot = nativeScene:GetRootNode();
    sceneRoot.Active = true;
    return true;
  end
  return false;
end

function BaseScene:_BeginUpdate(def)
  local _oldGetOrCreateScene = apolloengine.SceneManager.GetOrCreateScene;
  apolloengine.SceneManager.GetOrCreateScene = function()
    return self.nativeScene;
  end
  return _oldGetOrCreateScene;
end

function BaseScene:Update(def)

  --renderqueue运行期有可能改变，更新需要渲染的RT
  self:_LinkToRenderQueue();
  
  
  local _oldGetOrCreateScene = self:_BeginUpdate(def);
  
  if self.nativeScene then
    self.nativeScene:Update(def);
  end
  
  self:_EndUpdate(_oldGetOrCreateScene);
end

function BaseScene:_EndUpdate(getOrCreateScene)
  apolloengine.SceneManager.GetOrCreateScene = getOrCreateScene;
end


function BaseScene:_SetupNode(node)
  --一个素材一个Scene应该不需要ResourceType标记了
  if node then
    local camComponent = node:GetComponent(apolloengine.Node.CT_CAMERA);
    if camComponent then
      camComponent:SetSequenceCulling(false);  --关闭Sequence Culling
      local camLayer = camComponent.LayerMask;
      if camComponent:GetAttachedRenderTarget() == nil then
        table.insert(self.outputCamera,camComponent);
      end
    end
  end
  local subNodes = node:GetChildrens();
  for k,v in pairs(subNodes) do
    self:_SetupNode(v);
  end
end

--目前一个素材一个Scene，不用在设置ResourceType标记了
--只需要把最终的输出相机找出来，给输出相机挂同一个FBO
function BaseScene:_Setup(scene)
  scene:SetSequence(self.sceneSequence);
  local sceneRoot = scene:GetRootNode();
  self:_SetupNode(sceneRoot);
  --将场景输出再插回renderqueue
  self:_CreateInternalNode(scene);
  self:_LinkToRenderQueue(scene);
  return true;
end

--为了不修改素材主相机的是否清屏设置
--创建个quad把上一层的内容贴过来
--默认default层，与编辑器保持一致（编辑器中preview窗口也有一个default层的quad)
function BaseScene:_CreateInternalNode(scene)
  self.internalNode = scene:CreateNode(apolloengine.Node.CT_NODE);
  self.internalNode:SetName("Base internal node");
  local internalRender = self.internalNode:CreateComponent(apolloengine.Node.CT_RENDER);
  
  internalRender:PushMetadata(
    apolloengine.RenderObjectMaterialMetadata(
      apolloengine.PathMetadata(defined.blit_material_path)));
  internalRender:PushMetadata(
    apolloengine.RenderObjectMeshMetadate( 
    apolloengine.RenderComponent.RM_TRIANGLES,      
    apolloengine.QuadVertexMetadata(true, false),
    apolloengine.QuadIndicesMetadata()));
  internalRender:CreateResource();
  
  internalRender:EraseRenderProperty(apolloengine.RenderComponent.RP_CULL);

  local tt = self.internalNode:GetLayer();
  local internalTex = renderqueue:GetTexture(self.insertLayer);

  if apolloengine.Framework:IsCurrentAdvancedShading() then
    self.gtlConverter:SetCamTexEntity(internalTex);
    internalRender:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,self.gtlConverter.sRGB_Transfer.texture);
  else
    internalRender:SetParameter(apolloengine.ShaderEntity.TEXTURE_DIFFUSE,internalTex);
  end
end


function BaseScene:_LinkToRenderQueue()

  local currentLayer, _ = renderqueue:_FindLayer(self.insertLayer);
  local currentLayerIndex = currentLayer.index;
  local nextLayer = renderqueue:_GetNextActiveLayer(currentLayerIndex);
  --if self.outputLayer ~= nextLayer.id then
    self.outputLayer = nextLayer.id;
    local nextLayerLastCamera = renderqueue:GetCamera(nextLayer.id);
    local nextLayerLastRT = nextLayerLastCamera:GetAttachedRenderTarget();

    if apolloengine.Framework:IsCurrentAdvancedShading() then

      local cameraComp = self.ltgConverter.sRGB_Transfer.cameraNode:GetComponent(apolloengine.Node.CT_CAMERA);
      cameraComp:DetachRenderTarget(self.ltgConverter.sRGB_Transfer.renderTarget);
      if nextLayerLastRT then
        cameraComp:AttachRenderTarget(nextLayerLastRT);
      end

      for i = 1, #self.outputCamera do
        local cam = self.outputCamera[i];
        cam:AttachRenderTarget(self.ltgConverter.sRGB_Transfer.renderTarget);
      end

      self.ltgConverter:SetCamTexEntity(
        self.ltgConverter.sRGB_Transfer.renderTarget:GetAttachment(apolloengine.RenderTargetEntity.TA_COLOR_0));

    else
      if nextLayerLastRT then
        for i = 1, #self.outputCamera do
          local cam = self.outputCamera[i];
          cam:AttachRenderTarget(nextLayerLastRT);
        end
      end
    end
  --end
end



function BaseScene:ReleaseResource()
  --将整个scene删掉
  --不能直接删除scene(很恶心)
  --直接删除scene,无法调用到脚本扩展component的_OnDestroy
  if self.nativeScene and not venuscore.isNil(self.nativeScene) then
    local sceneRoot = self.nativeScene:GetRootNode();
    if sceneRoot and not venuscore.isNil(sceneRoot) then
      
      --确保behavior中删除Node时,能拿到正确的Scene
      local _oldGetOrCreateScene = self:_BeginUpdate();
      self.nativeScene:DeleteNode(sceneRoot);
      self:_EndUpdate(_oldGetOrCreateScene);
      
    end
    --apolloengine.SceneManager:DeleteSceneById(self.nativeScene:GetStaticID());
    local sceneID = self.nativeScene:GetStaticID();
    apolloengine.SceneManager:DeleteSceneByID(sceneID);
  end
  self.outputCamera = {};
  self.nativeScene = nil;
  self.scenePath = nil;
end

return BaseScene;
