local apolloengine = require "apolloengine"

local utils = {}

function utils:GetBehavior(node, name)
  local script_component = node:GetComponent(apolloengine.Node.CT_SCRIPT)
  if script_component ~= nil then
    for sckey, scvalue in pairs(script_component.Instances) do
      if string.find(sckey, name) then
        return scvalue
      end
    end
  end
  return nil
end

function utils:GetFirstBehavior(node, names)
  local script_component = node:GetComponent(apolloengine.Node.CT_SCRIPT)
  if script_component ~= nil then
    for sckey, scvalue in pairs(script_component.Instances) do
      for _, name in ipairs(names) do
        if string.find(sckey, name) then
          return scvalue
        end
      end
    end
  end
  return nil
end

return utils