
local venuscore = require "venuscore"
local apolloengine = require "apolloengine"
local MotionSwitchLogic = venuscore.VenusBehavior:extend("MotionSwitchLogic");

local animationswitchpath = "scrs:behavior/animation/animationSwitch.lua"

function MotionSwitchLogic:new()
    self.curAniIdx = 0;
    self.animationIndex = 0;
    self.dftAnimIdx = 0;
    self.dftplayed = false;
    self.onStarted = false;
end

function MotionSwitchLogic:_OnAwake()
    if self.animationswitch ~= nil then
        self.AnimationSwitchScript = self.animationswitch:GetScript(animationswitchpath);
    end
end

function MotionSwitchLogic:DoOnStart()
    local animationComp = self.Node:GetComponent(apolloengine.Node.CT_ANIMATION);
    local aninames = nil;
    if self.AnimationSwitchScript then
      aninames = self.AnimationSwitchScript.animationInfo["name"];
    end
    if self.dftAnimIdx>0 and aninames and aninames[self.dftAnimIdx] then
      animationComp:Loop(aninames[self.dftAnimIdx],true);
    end
end

function MotionSwitchLogic:_OnUpdate(def)
    if self.onStarted == false then
        self:DoOnStart();
        self.onStarted = true;
        return;
    end
    if self.AnimationSwitchScript == nil then
        WARNING("MotionSwitchLogic AnimationSwitchScript is nil");
        return;
    end

    if self.dftplayed==false then
       if _KRATOSEDITOR then
        self.animationIndex = self.dftAnimIdx;
       end
       self:PlayAnimation(self.dftAnimIdx);
       self.dftplayed = true;
    end

    if _KRATOSEDITOR then
       self:PlayAnimation(self.animationIndex);
    end
    
    --self:UpdateMotion(def);
end

function MotionSwitchLogic:UpdateMotion(def)
  if self.curAniIdx > 0 then
    if self.curAniIdx~=self.dftAnimIdx then
      local isFinish = self.AnimationSwitchScript:IsCurStatePlayFinish();
      if isFinish == true then
          self:PlayAnimation(self.dftAnimIdx);
          if _KRATOSEDITOR then
              self.animationIndex = self.dftAnimIdx;
          end
      end
    end
  end
end

function MotionSwitchLogic:PlayAnimation(animIdx)
    if self.AnimationSwitchScript:IsInited()==false then
        WARNING("AnimationSwitchScript is not Inited!");
        return;
    end
  
    if self.curAniIdx == animIdx then
        return;
    end
    local animationComp = self.Node:GetComponent(apolloengine.Node.CT_ANIMATION);
    
    if animIdx > 0 then
        self.AnimationSwitchScript:SwitchAnimationByIdx(animIdx);
        local bRunning = self.AnimationSwitchScript:IsRunning();

        if not bRunning then
            WARNING("StateMachine is not running, need to start!");
            self.AnimationSwitchScript:Run();
        end

        if _KRATOSEDITOR then
            self.animationIndex = animIdx;
        end
    end

    self.curAniIdx = animIdx;
end

MotionSwitchLogic:MemberRegister("dftAnimIdx");
MotionSwitchLogic:MemberRegister("animationIndex");

MotionSwitchLogic:MemberRegister("animationswitch",
venuscore.ScriptTypes.ReferenceType(
apolloengine.ScriptComponent:RTTI()
));

return MotionSwitchLogic;
