local mathfunction = require "mathfunction"


local simpleretarget = {}

function simpleretarget:Initialize(targetbonepose)
  self.bonepose = {}
 
  self.targetbonepose = {}
  for i = 1,14 do
      self.targetbonepose [i]= mathfunction.vector3(targetbonepose[i][1],targetbonepose[i][2],targetbonepose[i][3]) ;
  end
  
  self.targetheight = self:GetTotalHeight(self.targetbonepose);
  self.targetwidth = self:GetBodyWidth(self.targetbonepose);

end

function simpleretarget:UpdateBoneData(bonepose)
   for i = 1,14 do
      self.bonepose [i]= mathfunction.vector3(bonepose[i][1],bonepose[i][2],bonepose[i][3]) ;
  end
  self.height = self:GetLegHeight(self.bonepose);
  self.ydelta = self:GetLegYDelta(self.bonepose);
  self.width = self:GetBodyWidth(self.bonepose);
  self.bodyMid,self.midLine = self:GetBodyMid(self.bonepose);
  
  self.leftKnee = self.bonepose[11];
  self.leftFoot = self.bonepose[12];
  self.rightKnee = self.bonepose[8];
  self.rightFoot = self.bonepose[9];
  
  --self.midline = 
  
  self.leftKneeXScale =  (self.leftKnee - self.bodyMid):Length()/(self.width/2)
  self.leftFootXScale =  (self.leftFoot - self.bodyMid):Length()/(self.width/2)
  self.rightKneeXScale =  (self.leftKnee - self.bodyMid):Length()/(self.width/2)
  self.rightFootXScale =  (self.rightFoot - self.bodyMid):Length()/(self.width/2)
  
  self.heighttime = self.targetheight/self.height;
  self.widtthtime = self.targetwidth/self.width;
  self.heightscale = self.heighttime /self.widtthtime;
  if self.heightscale>2 then
    self.heightscale =2 
  end
  self.ydelta2height = self.ydelta/self.height;
  if self.ydelta2height<0.9 then
    self.ydelta2height = self.ydelta2height*0.8
  end
end


function simpleretarget:GetTotalHeight(bonepose)
  local nechead = bonepose[14] - bonepose[13]
  
  local rupbody =bonepose[1] -  bonepose[7]
  local rupleg = bonepose[7] -  bonepose[8]
  local rlowleg =bonepose[8] -  bonepose[9]

  local lupbody =bonepose[2] -  bonepose[10]
  local lupleg = bonepose[10] - bonepose[11]
  local llowleg =bonepose[11] - bonepose[12]
  
  local rlen = rupbody:Length()+rupleg:Length()+rlowleg:Length();
  local llen = lupbody:Length()+lupleg:Length()+llowleg:Length();
  
  return (rlen+llen)/2;
end

function simpleretarget:GetLegHeight(bonepose)
  
  local rupleg = bonepose[7] -  bonepose[8]
  local rlowleg =bonepose[8] -  bonepose[9]
  
  local lupleg = bonepose[10] - bonepose[11]
  local llowleg =bonepose[11] - bonepose[12]
  
  local rlen = rupleg:Length()+rlowleg:Length();
  local llen = lupleg:Length()+llowleg:Length();
  
  return (rlen+llen)/2;
end

function simpleretarget:GetLegYDelta(bonepose)
  
  local rupleg = bonepose[7]:y() -  bonepose[8]:y()
  local rlowleg =bonepose[8]:y() -  bonepose[9]:y()
  
  local lupleg = bonepose[10]:y() - bonepose[11]:y()
  local llowleg =bonepose[11]:y() - bonepose[12]:y()
  
  local rlen = rupleg+rlowleg;
  local llen = lupleg+llowleg;
  
  return -(rlen+llen)/2;
end

function simpleretarget:GetBodyWidth(bonepose)
  local wvec = bonepose[10] - bonepose[7];
  return wvec:Length();
end

function simpleretarget:GetBodyMid(bonepose)
  local wvec = (bonepose[10] + bonepose[7])/2;
  local up = (bonepose[10] + bonepose[7])/2;
  up = up - wvec;
  up:NormalizeSelf();
  return wvec,up;
end

function simpleretarget:Retarget(position)
  self:UpdateBoneData(position);
  for i=7,#position -2 do
    local vv = position[i][2]*self.heightscale* self.ydelta2height
    position[i][2] = vv
  end
  --if self.leftKneeXScale>1 then
  
  
  return position;
end

return simpleretarget;
