local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"
local ncnn = require "ncnnfunction"
local videodecet = require "videodecet"
local apollonode = require "apolloutility.apollonode"
local oneeurofilter = require "math.lowpassfilter.oneeurofilter"
local skeletonfit = require "avatar.skeletonfit_combo_pos"
local cameraestimate = require "avatar.cameraestimate"
local Rodrigues = require "torchutility.rodrigues"
local AutoTensor =  require "torchutility.autotensor"
local ikavatar = require "avatar.ikavatar"
require "utility"


local poseestimates14 = {}


local std3d = {
  110.7224395224947,
  22.388176174254347,
  72.46294421720373,
  158.56311079063173,
  189.33832206725427,
  208.80479145798353,
  191.79935232131172,
  243.2006168338775,
  247.56193295984693,
  110.72180724487369,
  22.38805433286514,
  72.46252568188349,
  158.80454092789694,
  199.77187809476604,
  214.7062978421496,
  180.01944122294572,
  250.52739312762094,
  248.53247137512838,
  95.15366543888481,
  101.33031820020669,
  128.9973251543324,
  123.6029657528179,
  130.85538909944856,
  164.33336500814266,	
  146.02231892533874,
  97.0795598515937,
  139.52731252584186,
  243.47531766057696,
  129.82248593326003,
  202.30181232857467,
  244.6877004789904,
  215.01816411816674,
  239.3823472541272,
  138.760844460741,
  100.89260001133229,
  142.44109658418054,
  236.87528986742385,
  144.91219013036826,
  209.80829096235226,
  244.00694913404305,
  239.7502834976899,
  255.20583985806599,
}

local mean3d = {
  -0.2556525886947795,
  -7.119605727416116,
  -0.9814330584948388,
  -5.654630512911183,
  319.63600940520956,
  71.93292692469369,
  -10.170583994141206,
  691.147891657268,
  155.35298624455555,
  0.2556513148981795,
  7.119546036952688,
  0.9814238602344578,
  -5.097297795487889,
  327.0404131275415,
  72.22580948277306,
  -9.996566061820296,
  708.2773832914069,
  158.01640791345199,
  5.6753780407515935,
  -435.08890570553115,
  -97.69740161233229,
  7.373520833615209,
  -583.9486185314574,
  -131.17140035921526,
  5.4192065289241445,
  -383.9317019573139,
  -86.81454166710293,
  2.959646625166301,
  -187.56748832018525,
  -43.453693436849946,
  1.26585821672136,
  -120.17057902524314,
  -28.252604914874993,
  4.671866390210052,
  -383.64408934471885,
  -85.51257837102308,
  1.6764857129649644,
  -197.00717718979865,
  -43.136836346611325,
  0.8705690141490188,
  -168.66456902427169,
  -37.39024980077856,
  -37.39024980077856,
}
      
      local gtmean2d = {
        --532.0835163565547,419.74137558120003,
        531.8095314362356,418.2607140959499,
        530.6845696830876,493.54259286466254,
        529.3696872290743,575.9644851654803,
        532.2976764528628,421.28483334982246,
        531.939466313509,494.7218679310468,
        529.7198444740386,578.9611036393283,
        --532.9369938236075,370.65225055228814,
        534.110185586839,317.903423113612,
        534.8695500439201,282.31030885794667,
        534.1130856750716,330.1129679287782,
        533.5363752584062,376.27425107952274,
        533.4938010568245,391.7232456145298,
        533.5257914249777,330.09494668526725,
        532.5080496257572,374.1904790365164,
        532.7278693355262,380.61615718919944
      }
      
      local gtstd2d = {
        --107.73640056632647,63.35908715293127,
        119.00836215445092,64.12154429274791,
        119.12412106402572,50.538062145059534,
        120.6168804143148,56.38444889286369,
        101.95735272862534,62.89636485952771,
        106.24832896571219,48.41178119137708,
        108.46734963957013,54.581770692384666,
       -- 109.07369806463174,68.70443671531466,
        111.20130350472374,74.87287863300989,
        113.2233078961136,79.90670556162974,
        105.71458330124277,73.27049437203256,
        107.05804267166643,73.93175782533872,
        107.97449418517449,83.30391805242135,
        121.60675105903508,74.25691527749441,
        134.3437897403436,77.48125087680438,
        131.79990652239553,89.8672112391702
      }
      
local namebonemapping14 = 
{
  ["RightUpLeg"] = 4,
  ["RightLeg"] = 5,
  ["RightFoot"] = 6,
  ["LeftUpLeg"] = 1,
  ["LeftLeg"] = 2,
  ["LeftFoot"] = 3,
  ["Neck"] = 7,
  ["Head"] = 8,
  ["LeftArm"] = 12,
  ["LeftForeArm"] = 13,
  ["LeftHand"] = 14,
  ["RightArm"] = 9,
  ["RightForeArm"] = 10,
  ["RightHand"] = 11,
}

local rotateDetermMap = 
{

  ["RightUpLeg"] = "RightLeg",
  ["RightLeg"] = "RightFoot",
  ["LeftUpLeg"] = "LeftLeg",
  ["LeftLeg"] = "LeftFoot",
  ["Neck"] = "Head",
  ["LeftArm"] = "LeftForeArm",
  ["LeftForeArm"] = "LeftHand",
  ["RightArm"] = "RightForeArm",
  ["RightForeArm"] = "RightHand",
}




local freebonename = {
  "m_avg_Pelvis",    --1
  "m_avg_L_Hip",    --2
  "m_avg_R_Hip",    --3
  "m_avg_L_Knee",    --4
  "m_avg_R_Knee",    --5
  "m_avg_L_Ankle",    --6
  "m_avg_R_Ankle",    --7
  "m_avg_L_Shoulder", --8
  "m_avg_R_Shoulder", --9
  "m_avg_L_Elbow", --10
  "m_avg_R_Elbow", --11
  "m_avg_L_Wrist", --12
  "m_avg_R_Wrist", --13
}

--根据自由变量的位置匹配
local bonepair = {
  {2, 3}, -- body
  {8, 9},
  {2, 8},
  {3, 9},
  
  {1, 2}, --lleg
  {2, 4},
  {4, 6},
  
  {1, 3}, --rleg
  {3, 5},
  {5, 7},
  
  {1, 8}, --larm
  {8, 10},
  {10, 12},
  
  {1, 9}, --rarm
  {9, 11},
  {11, 13},
}

local function _CreateSmallCube()
  local target = apollonode.MeshNode();
  target:CreateResource(
    "comm:documents/model/cube.mesh", 
    "comm:documents/material/lightingonly.material");
  target:SetBindBox(
    mathfunction.Aabbox3d(
      mathfunction.vector3(-0.5,-0.5,-0.5),
      mathfunction.vector3(0.5,0.5,0.5)));
  target:SetLocalScale( mathfunction.vector3(0.13,0.13,0.13) );
  return target;
end


function poseestimates14:Initialize()  
  self.inmat = ncnn.Mat();
  self.outmat = ncnn.Mat();
  self.net = ncnn.Net();
  self.net:LoadParam("docs:ncnn/prediect14/ncnn.proto");
  self.net:LoadModel("docs:ncnn/prediect14/ncnn.bin");

  --self.net:LoadParam("E:/workspace/algo_video_facecute/venussdk/documents/ncnn/ncnn.proto");
  --self.net:LoadModel("E:/workspace/algo_video_facecute/venussdk/documents/ncnn/ncnn.bin");
  
   
  self.renders = {}
  self.nodes = {}
  self.trans = {}
  self.eurofilters = {}

  self.currentTime = 0;
  self.fit = skeletonfit;
  self.fit:Initialize();
   
  self.bonelength = nil;
  
  self.testModel = apollonode.ModelNode();
  self.testModel:CreateResource("comm:documents/model/male");
  self.testModel:SetShow(false);
  
  
  local boneposition = {}
  local jointnames = self.testModel:GetJointNames();
  for _, name in ipairs(jointnames) do
    local joint = self.testModel:GetJoint(name);
    local wpos = joint:GetWorldPosition();
    boneposition[name] = wpos;
  end
  
  self.boneposition = {};
  self.modulecenter = boneposition["m_avg_Pelvis"];
  for name, wpos in pairs(boneposition) do
    local npos = wpos - self.modulecenter;
    self.boneposition[name] = npos;--{npos:x(), npos:y(), npos:z()};
  end
  
  skeletonfit:SetupBoneLength(self.boneposition, freebonename, bonepair);
  
  self.cubes = {}
  for _, name in ipairs(freebonename) do
    local cube = _CreateSmallCube()
    self.cubes[name] = cube;
    self.cubes[name]:SetShow(false);
  end
  
  self.worldposition = mathfunction.vector3(0, -2, -6);
  ikavatar:Initialize(self.worldposition);
end

function poseestimates14:redirect(points2d)
  local result = {}


  --rleg
  result[1] =   points2d[19];
  result[2] =    points2d[20];
  result[3] =    points2d[23];
  result[4] =    points2d[24];
  result[5] =    points2d[27];
  result[6] =    points2d[28];
  --lleg
  result[7] = points2d[17];
  result[8] =points2d[18];
  result[9] =points2d[21];
  result[10] =points2d[22];
  result[11] =points2d[25];
  result[12] =points2d[26];
  --xiong
  local chestx = (points2d[5]+points2d[7])/2;
  local chesty = (points2d[6]+points2d[8])/2;

  --bozi
  result[13] = points2d[3];
  result[14] = points2d[4];
  --head
  result[15] =  points2d[1];
  result[16] =  points2d[2];

  --LARM
  result[17] = points2d[5]; 
  result[18] = points2d[6]; 
  result[19] = points2d[9]; 
  result[20] = points2d[10];
  result[21] = points2d[13];
  result[22] = points2d[14];
  --RARM
  result[23] =   points2d[7];
  result[24] =   points2d[8];
  result[25] =   points2d[11];
  result[26] =   points2d[12];
  result[27] =   points2d[15];
  result[28] =   points2d[16];
  return result;
end

function poseestimates14:Estimates(timespan)

  self.currentTime=timespan+self.currentTime;
  local scenetimepoint2ds = videodecet:GetBodyPoints();--像素坐标
  local totalcount = table.getn(scenetimepoint2ds)
 
  if totalcount==0 then 
    return false;
  end
  for i = 1 ,totalcount do
    if scenetimepoint2ds[i]==-1 then 
      if self.lastpoints2ds~=nil and self.lastpoints2ds[i]~=nil and self.lastpoints2ds[i]~=-1 then
        LOG("no full bones,use last frame data!!! "..totalcount);
        return false;
      else
        LOG("no full bones,return!!! "..totalcount);
        return false;
      end
    end
  end
  local estimate2darray = self:redirect(scenetimepoint2ds);
  local inputpointsdata = self:redirect(scenetimepoint2ds);
  for i = 1 ,28 do
    inputpointsdata[i] = (inputpointsdata[i]-gtmean2d[i])/gtstd2d[i];
  end
  
  self.inmat:Fill(inputpointsdata);  
  
  self.extractor = self.net:CreateExtractor();  
  local count = venuscore.IServicesSystem:GetThreadCount();
  self.extractor:SetNumThreads(count/2); 
  self.extractor:Input("inputs/enc_in", self.inmat);
  self.extractor:Extract("linear_model/add_1", self.outmat);
  local outarray = self.outmat:AsFloatArray();
  local estimate3darray = {}
  for i = 1 ,42 do
    estimate3darray[i] = outarray[i]*std3d[i]+mean3d[i];
  end
  
  --reset model
  local skeleton = self.testModel.skeletonNode.skeleton;

  --****************************center2dpoints**********************************--
  local videosize = videodecet:GetVideoSize();
  local realres = apolloengine.Framework:GetResolution();
  local s_x = realres:x() / videosize[1];
  local s_y = realres:y() / videosize[2];
  
  for i=1, #estimate2darray/2 do
    local idx1 = (i-1)*2+1;
    local idx2 = (i-1)*2+2;
    estimate2darray[idx1] = estimate2darray[idx1] *s_x ;                    --  -50and-250 is hack offset for pnp estimate.
    estimate2darray[idx2] = realres:y()-estimate2darray[idx2] *s_y ;
  end
  --********************************************************************************--
  local torso2d = {};
  local torso3d = {};
  
  
  local idxLeftShoulder = namebonemapping14["LeftArm"];
  local idxRightShoulder = namebonemapping14["RightArm"];
  local idxLeftHip = namebonemapping14["LeftUpLeg"];
  local idxRightHip = namebonemapping14["RightUpLeg"];
  
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxLeftShoulder*2-1],estimate2darray[idxLeftShoulder*2]  ))
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxRightShoulder*2-1],estimate2darray[idxRightShoulder*2]))
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxLeftHip*2-1],estimate2darray[idxLeftHip*2]            ))
  table.insert(torso2d,mathfunction.vector2(estimate2darray[idxRightHip*2-1],estimate2darray[idxRightHip*2]          ))
  
  local ls = self.boneposition["m_avg_L_Shoulder"];
  local rs = self.boneposition["m_avg_R_Shoulder"];
  local lh = self.boneposition["m_avg_L_Hip"];
  local rh = self.boneposition["m_avg_R_Hip"];
  table.insert(torso3d, ls)--ls
  table.insert(torso3d, rs)--rs
  table.insert(torso3d, lh)--lh
  table.insert(torso3d, rh)--rh

  local focalelength = math.max(realres:x(),realres:y());
  --local zoffset,offset2d = cameraestimate:Estimate(focalelength,realres:x()/2,realres:y()/2,torso2d,torso3d);
  local zoffset = 4;
  local offset2d = {0,0}
  local cameraoffset = {0,0,zoffset};
  
  local centeredpoint2d = {}
  for i=1, #estimate2darray/2 do
    local idx1 = (i-1)*2+1;
    local idx2 = (i-1)*2+2;
    centeredpoint2d[idx1] = estimate2darray[idx1] - offset2d[1] ;                    --  -50and-250 is hack offset for pnp estimate.
    centeredpoint2d[idx2] = estimate2darray[idx2] - offset2d[2] ;
  end
  
  --估算相对单位
  local centeredpoint3d = {}
  for i = 1 ,42, 3 do
    local pos = mathfunction.vector3(
      estimate3darray[i],
      -estimate3darray[i+1], --inverse 3d pose upside down
      estimate3darray[i+2]);
    table.insert(centeredpoint3d, pos);
  end
  local els = centeredpoint3d[namebonemapping14["LeftArm"]];     
  local ers = centeredpoint3d[namebonemapping14["RightArm"]];
  local elh = centeredpoint3d[namebonemapping14["LeftUpLeg"]]; 
  local erh = centeredpoint3d[namebonemapping14["RightUpLeg"]];
  
  local unit = ((lh - ls):Length() + (rh - rs):Length()) / ((elh - els):Length() + (erh - ers):Length());
  
  for i, v in ipairs(centeredpoint3d) do
    centeredpoint3d[i] = v * unit;
  end
  --****************************proj**********************************--
  
  self.lastpoints2ds = estimate2darray;
  local vec3list = {};
  vec3list[1] = mathfunction.vector3(); --pelvis
  vec3list[2] = centeredpoint3d[namebonemapping14["LeftUpLeg"]];
  vec3list[3] = centeredpoint3d[namebonemapping14["RightUpLeg"]];
  vec3list[4] = centeredpoint3d[namebonemapping14["LeftLeg"]];
  vec3list[5] = centeredpoint3d[namebonemapping14["RightLeg"]];
  vec3list[6] = centeredpoint3d[namebonemapping14["LeftFoot"]];
  vec3list[7] = centeredpoint3d[namebonemapping14["RightFoot"]];
  vec3list[8] = centeredpoint3d[namebonemapping14["LeftArm"]];     
  vec3list[9] = centeredpoint3d[namebonemapping14["RightArm"]];     
  vec3list[10] = centeredpoint3d[namebonemapping14["LeftForeArm"]];
  vec3list[11] = centeredpoint3d[namebonemapping14["RightForeArm"]];
  vec3list[12] = centeredpoint3d[namebonemapping14["LeftHand"]]; 
  vec3list[13] = centeredpoint3d[namebonemapping14["RightHand"]];   

  local vec2list = {};

  vec2list[1] = {centeredpoint2d[namebonemapping14["LeftUpLeg"]*2-1],  centeredpoint2d[namebonemapping14["LeftUpLeg"]*2]};
  vec2list[2] = {centeredpoint2d[namebonemapping14["RightUpLeg"]*2-1],  centeredpoint2d[namebonemapping14["RightUpLeg"]*2]};
  vec2list[3] = {centeredpoint2d[namebonemapping14["LeftLeg"]*2-1],    centeredpoint2d[namebonemapping14["LeftLeg"]*2]};
  vec2list[4] = {centeredpoint2d[namebonemapping14["RightLeg"]*2-1],    centeredpoint2d[namebonemapping14["RightLeg"]*2]};
  vec2list[5] = {centeredpoint2d[namebonemapping14["LeftFoot"]*2-1],   centeredpoint2d[namebonemapping14["LeftFoot"]*2]};
  vec2list[6] = {centeredpoint2d[namebonemapping14["RightFoot"]*2-1],   centeredpoint2d[namebonemapping14["RightFoot"]*2]};  
  vec2list[7] = {centeredpoint2d[namebonemapping14["LeftArm"]*2-1],centeredpoint2d[namebonemapping14["LeftArm"]*2]};
  vec2list[8] = {centeredpoint2d[namebonemapping14["RightArm"]*2-1],centeredpoint2d[namebonemapping14["RightArm"]*2]};  
  vec2list[9] = {centeredpoint2d[namebonemapping14["LeftForeArm"]*2-1],centeredpoint2d[namebonemapping14["LeftForeArm"]*2]};
  vec2list[10] = {centeredpoint2d[namebonemapping14["RightForeArm"]*2-1],centeredpoint2d[namebonemapping14["RightForeArm"]*2]};
  vec2list[11] = {centeredpoint2d[namebonemapping14["LeftHand"]*2-1],centeredpoint2d[namebonemapping14["LeftHand"]*2]};
  vec2list[12] = {centeredpoint2d[namebonemapping14["RightHand"]*2-1],centeredpoint2d[namebonemapping14["RightHand"]*2]};
  
  local vec3listtable = {}
  for i, value in ipairs(vec3list) do
    vec3listtable[i] = {value:x(), value:y(), value:z()};
  end

  self.fit:SetCamera(math.max(realres:x(), realres:y()),math.max(realres:x(), realres:y()),realres:x()*0.5,realres:y()*0.5);
  local pos_vec = self.fit:EstimateRotation(vec3listtable, vec2list, cameraoffset);

  --[[
  local moduleoffset = pos_vec[1];
  LOG("bone root at pos "..tostring(moduleoffset));   
  self.testModel:SetLocalPosition(self.worldposition + moduleoffset);
  for i=2, #freebonename do
    local name = freebonename[i];
    local pos = pos_vec[i] + self.worldposition + self.modulecenter - moduleoffset;
    LOG("bone "..name.." at pos "..tostring(pos));    
    --self.cubes[name]:SetLocalPosition(pos);
    
   -- local init_pos = vec3list[i] + modulepos + self.modulecenter;
    --self.cubes[name]:SetLocalPosition(init_pos);
  end 
  ]]--
  
  local bonenamelist = {
  
  
  "LeftUpLeg",
  "RightUpLeg",
  "LeftLeg",
  "RightLeg",
  "LeftFoot",
  
 
  
  "RightFoot",
  
  "LeftArm"     ,
  "RightArm",
  "LeftForeArm" ,
  "RightForeArm",
  "LeftHand",
 
  
  "RightHand" ,
  
  }
  local bones = {}
  
  bones[1] = {};
  bones[1].children = {};
  bones[1].pos =  pos_vec[1];
  bones[1].name = root;
  for i=2,13 do
    bones[i] = {};
    bones[i].name = bonenamelist[i-1];
    bones[i].children = {};
    bones[i].pos =  pos_vec[i];
    local tdir = self:GetTDir(bonenamelist[i-1]);
    if tdir~=false then
      bones[i].tdir = tdir;
    end
  end
  
  local fatherlist = {0,1,1,2,3,4,5,1,1,8,9,10,11}
  for i=1,#fatherlist do
    if fatherlist[i] ~= 0 then
      bones[i].father = bones[fatherlist[i]];
      table.insert(bones[fatherlist[i]].children,bones[i]);
    end
  end
    
    
  local rotatelist = {};
  self:SetupBoneRotate( bones[1]);
  
  for i=1,12 do
    if bones[i+1].rotmat == nil then
      rotatelist[i] = 0;
    else
      rotatelist[i] = bones[i+1].rotmat;
    end
  end

  local replaceidx =  self:GetSubProjList();
  
  local worldrot = self:GetBoneRotate(rotatelist);
  local bonename = {
    "m_avg_Pelvis" ,
    "m_avg_L_Hip" ,
    "m_avg_R_Hip" ,
    "m_avg_Spine1" ,
    "m_avg_L_Knee" ,
    "m_avg_R_Knee" ,
    "m_avg_Spine2" ,
    "m_avg_L_Ankle" ,
    "m_avg_R_Ankle" ,
    "m_avg_Spine3" ,
    "m_avg_L_Foot" ,
    "m_avg_R_Foot" ,
    "m_avg_Neck" ,
    "m_avg_L_Collar" ,
    "m_avg_R_Collar" ,
    "m_avg_Head" ,
    "m_avg_L_Shoulder" ,
    "m_avg_R_Shoulder" ,
    "m_avg_L_Elbow" ,
    "m_avg_R_Elbow" ,
    "m_avg_L_Wrist" ,
    "m_avg_R_Wrist" ,
    "m_avg_L_Hand" ,
    "m_avg_R_Hand" ,
  }
  
  local targets = {}
  for i=1, #replaceidx do
    local name = bonename[replaceidx[i]];
    local joint = self.testModel.skeletonNode:GetJoint(name);
    local transform = joint.node:GetComponent(apolloengine.Node.CT_TRANSFORM);
    local rotate = mathfunction.vector3( worldrot[i][1],worldrot[i][2],worldrot[i][3]);
    local angle = rotate:Length();
    local dir = rotate:Normalize();
    local quaternion = mathfunction.Quaternion();
    if angle<0.0001 then
      dir =  mathfunction.vector3(0,0,1);
    end
    quaternion:RotateAxis(dir,angle)
    transform:SetWorldRotation(quaternion);
    targets[name] = transform:GetWorldPosition() + self.worldposition;
    self.cubes[name]:SetLocalPosition(targets[name]);
  end
  
  ikavatar:Update(targets);
  
  return true;
end

function poseestimates14:GetTDir(jointname)
  if rotateDetermMap[jointname] ==nil then
    return false
  end
  local index1 = namebonemapping14[jointname];
  local index2 = namebonemapping14[rotateDetermMap[jointname]];
  if index1==nil or index2==nil then
    return false
  end

  pos1 = self:TPose()[index1];
  pos2 = self:TPose()[index2];
  local dir2 =  pos1 - pos2;
  dir2:NormalizeSelf();

  return dir2;
end

function poseestimates14:GetSubProjList()
  return { 2,3,5,6,8,9,17,18,19,20,21,22 };
end

function poseestimates14:GetBoneRotate(rotatemat)
  local svpose = {};
  
  --svpose[1] = {0,0,0};
 
  for i=1,#rotatemat do
    if rotatemat[i]~=0 then
      local rotvv = Rodrigues.Decompose(rotatemat[i]);
      svpose[i] = {};
      svpose[i][1] = rotvv[1];
      svpose[i][2] = rotvv[2];
      svpose[i][3] = rotvv[3];
    else
      svpose[i] = {0,0,0};
    end
    
  end

  return svpose;
end

function poseestimates14:TPose()
  if self.tpose ==nil then
    self.tpose  = {
      mathfunction.vector3(0.086,0.005,-0.026),
      mathfunction.vector3(0.066,-0.359,0.042),
      mathfunction.vector3(0.036,-0.715,-0.085),
      mathfunction.vector3(-0.086,-0.005,0.026),
      mathfunction.vector3(-0.089,-0.384,0.080),
      mathfunction.vector3(-0.111,-0.741,0.046),
      mathfunction.vector3(-0.023,0.624,0.078),
      mathfunction.vector3(-0.003,0.704,0.035),
      mathfunction.vector3(-0.155,0.400,0.017),
      mathfunction.vector3(-0.411,0.400,0.017),
      mathfunction.vector3(-0.585,0.400,0.017),
      mathfunction.vector3(0.155,0.399,-0.008),
      mathfunction.vector3(0.411,0.4,-0.008),
      mathfunction.vector3(0.585,0.4,-0.008),
    }

  end
  return self.tpose;
end

function poseestimates14:VectorToRot(fatherdir,mydir)
    if fatherdir == nil or mydir ==nil then
      local ret = mathfunction.vector3(0,0,0);
      return ret;
    end
    local norfadir = fatherdir:Normalize();
    local normydir = mydir:Normalize();
    local rotateaxis = norfadir:Cross(normydir);
    local costheta = norfadir:Dot(normydir);
    local sintheta =  rotateaxis:Length();
    --local theta = math.asin(sintheta);
    local theta = math.acos(costheta);
    local realtheta = theta;

    local temp = realtheta/sintheta;
    rotateaxis:Set(rotateaxis:x()*temp,rotateaxis:y()*temp,rotateaxis:z()*temp);
    return rotateaxis;
end

function poseestimates14:SetupBoneRotate(bone)
  if bone == nil then
    return;
  end

  if #bone.children ==1 then
    local dir = bone.pos - bone.children[1].pos;
    local startdir = nil;
    --if #bone.father.children ==1 then
    --  startdir = bone.father.pos- bone.pos;
    --else
    startdir = bone.tdir
    
    
    local worldrottemp = self:VectorToRot(startdir,dir);
    worldrottemp = AutoTensor({worldrottemp:x(), worldrottemp:y(),worldrottemp:z()});
    local mat = Rodrigues(worldrottemp):R();
    bone.rotmat = mat;
  end
  
  for i=1,#bone.children do
    self:SetupBoneRotate(bone.children[i],resultmat);
  end
end

return poseestimates14;