local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local Object = require "classic"
local venuscore = require "venuscore"
local apolloDefine = require "apolloutility.defiend"
--虚拟节点，不包含可渲染的组件
local VirtualNode = Object:extend();

function VirtualNode:new()

  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  self.node = scene:CreateNode(apolloengine.Node.CT_NODE);
  self.node:SetName("VirtualNode");
end

function  VirtualNode:SetName(name)
  self.node:SetName(name);
end

function  VirtualNode:CreateComponent(comtype)
  return self.node:CreateComponent(comtype);
end

function VirtualNode:GetComponent(comtype)
  return self.node:GetComponent(comtype);
end


function VirtualNode:AttachNode(input)
  self.node:AttachNode(input.node);
end

function VirtualNode:DetachNode(input)
  self.node:DetachNode(input.node);
end

function VirtualNode:SetLayer(layer)
  self.node:SetLayer(layer);
end

--目前Node需要自己手动删除
--提供一个接口方便删除facecute脚本node
function VirtualNode:Destroy()
  local scene = apolloengine.SceneManager:GetOrCreateScene(apolloDefine.default_scene_name);
  if not venuscore.isNil(self.node) then  --防止Node重复删除(因为删除父Node会递归删除子Node)
    scene:DeleteNode(self.node);
  end
end



return VirtualNode;