//////////////////////////////////////////////////////////////////////////////////////
//
//						The Bohge Engine License (BEL)
//
//	Copyright (c) 2011-2014 Peng Zhao
//
//	Permission is hereby granted, free of charge, to any person obtaining a copy
//	of this software and associated documentation files (the "Software"), to deal
//	in the Software without restriction, including without limitation the rights
//	to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
//	copies of the Software, and to permit persons to whom the Software is
//	furnished to do so, subject to the following conditions:
//
//	The above copyright notice and this permission notice shall be included in
//	all copies or substantial portions of the Software. And the logo of
//	Bohge Engine shall be displayed full screen for more than 3 seconds
//	when the software is started. Copyright holders are allowed to develop
//	game edit based on Bohge Engine, The edit must be released under the MIT
//	open source license if it is going to be published. In no event shall
//	copyright holders be prohibited from using any code of Bohge Engine
//	to develop any other analogous game engines.
//
//	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
//	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
//	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
//	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
//	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
//	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
//
//////////////////////////////////////////////////////////////////////////////////////

// 输出纹理坐标 等于 输入纹理坐标
#SHADER_DEFINE Eye2DCoordinate
    FUNCTION_INPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "in_Coordinate0" },
        { ATTRIBUTE_COORDNATE1,            MEDIUM,    VEC2,        "in_Coordinate1" },
    }

    FUNCTION_OUTPUT =
    {
        { ATTRIBUTE_COORDNATE0,            MEDIUM,    VEC2,        "out_Coordinate0" },
        { ATTRIBUTE_COORDNATE1,            MEDIUM,    VEC2,        "out_Coordinate1" },
    }
#SHADER_CODE
    mediump vec2 out_Coordinate0 = in_Coordinate0;
    mediump vec2 out_Coordinate1 = in_Coordinate1;

#END_CODE
#END_DEFINE


//输出在世界空间下的顶点属性
//输出两个变换矩阵
#SHADER_DEFINE EyeDollTransform
    FUNCTION_INPUT =
    {
        { CAMERA_VIEWPROJ,						HIGH,    MAT4,        "in_ViewPorj" },
        { LOCALWORLD_TRANSFORM,				HIGH,    MAT4,        "in_Transfrom" },
        { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
        { ATTRIBUTE_POSITION,					HIGH,    VEC4,        "in_Position" },
        { ATTRIBUTE_NORMAL,						HIGH,    VEC3,        "in_Normal" },
				{	ATTRIBUTE_TANGENT,					HIGH,    VEC3,        "in_Tangent"},
    }
    FUNCTION_OUTPUT =
    {
        { SCREENSPACE_POSITION,     	HIGH,    VEC4,        "out_Position" },
				{ WORLDSPACE_POSITION,        HIGH,    VEC3,        "out_PositionWS" },
        { WORLDSPACE_NORMAL,         	HIGH,    VEC3,        "out_NormalWS" },
    }
#SHADER_CODE
		vec4 out_Position = in_ViewPorj * in_Transfrom * in_Position;

		vec3 out_PositionWS  = (in_Transfrom * in_Position).xyz;
    vec3 out_NormalWS = (in_WorldRotation * in_Normal);

#END_CODE
#END_DEFINE


//计算人偶眼睛的直接光照
#SHADER_DEFINE EyeLighting

  FUNCTION_INPUT =
  {
    { ATTRIBUTE_COORDNATE0,			MEDIUM,		VEC2,					"in_Coordinate0" },
    { ATTRIBUTE_COORDNATE1,			MEDIUM,		VEC2,					"in_Coordinate1" },
    { TEXTURE_DIFFUSE,			  NONE,			TEXTURE2D,		"diffuseMap" },
    { TEXTURE_SPECULAR,			  NONE,			TEXTURE2D,		"specularMap" },
    { TEXTURE_HEIGHT,					NONE,			TEXTURE2D,		"heightMap" },
    { CAMERA_WORLDPOSITION,		HIGH,	     VEC3,	      "in_CameraPosition" },
    { WORLDSPACE_POSITION,		HIGH,      VEC3,        "in_PositionWS" },
    { MOVE_SPEED1,            MEDIUM,    FLOAT,        "movespeed1" },
    { MOVE_SPEED2,            MEDIUM,    FLOAT,        "movespeed2" },
    { MOVE_SPEED3,            MEDIUM,    FLOAT,        "movespeed3" },
    { SPEC_OFFSET1,           MEDIUM,    VEC3,         "specoffset1" },
    { SPEC_OFFSET2,           MEDIUM,    VEC3,         "specoffset2" },
    { SPEC_OFFSET3,           MEDIUM,    VEC3,         "specoffset3" },
    { INIT_OFFSET,            MEDIUM,    VEC3,         "initoffset" },
    { EYE_HEIGHT,             MEDIUM,    FLOAT,        "eyeheight" },
    { INTENSITY,              MEDIUM,    VEC3,         "intensity" },

    { LIGHT1DIR,              HIGH,         VEC3,          "in_LightDirection"},
    { LIGHT1COLOR,            HIGH,         VEC3,          "lightColor"},
    { LIGHT1INTENSITY,        HIGH,         FLOAT,         "Light1Intensity"},

    { AMBIENT_COLOR,            LOW,     VEC3,         "ambientColor" },
    { LOCALWORLD_ROTATION,				HIGH,    MAT3,        "in_WorldRotation" },
    { SURFACE_COLOR,				  HIGH,	        FLOAT,		"ShadowMask" },
  }
  FUNCTION_OUTPUT =
  {
		{ SURFACE_COLOR,			MEDIUM,	VEC4,	    		"out_Color" },
  }
#SHADER_CODE

  vec3 eyeright = in_WorldRotation * vec3(1.0, 0.0, 0.0);
  vec3 eyeup = in_WorldRotation * vec3(0.0, 1.0, 0.0);

  vec3 vView = normalize(in_CameraPosition - in_PositionWS);
  vec3 vLight = normalize(in_LightDirection);

  float vr = dot(vView, eyeright);
  float vu = dot(vView, eyeup);

  vec2 coord0 = vec2(-vr*vr*vr, -vr);
  coord0 *= movespeed1;
  coord0 *= specoffset1.xy;
  coord0 = coord0 + initoffset.xy + vec2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
  coord0.y = 1.0 - coord0.y;
  
  float specular0 = texture2D(specularMap, coord0).x;

  vec2 coord1 = vec2(vr, -vu);
  coord1 *= movespeed2;
  coord1 *= specoffset2.xy;
  coord1 = coord1 + initoffset.xy + vec2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
  coord1.y = 1.0 - coord1.y;
  float specular1 = texture2D(specularMap, coord1).y;

  vec2 coord2 = abs(vec2(vr, vr));
  coord2 *= movespeed3;
  coord2 *= specoffset3.xy;
  coord2 = coord2 + initoffset.xy + vec2(in_Coordinate1.x, 1.0 - in_Coordinate1.y);
  coord2.y = 1.0 - coord2.y;
  
  float specular2 = texture2D(specularMap, coord2).z;

  float totalSpecular = dot(vec3(specular0,specular1,specular2), intensity);

  vec2 heightOffset = vec2(vr, -vu) * eyeheight * 0.5;
  float height0 = texture2D(heightMap, in_Coordinate0).x;

  vec2 hcoord1 = vec2(height0) * heightOffset + vec2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
  hcoord1.y = 1.0 - hcoord1.y;
  
  float height1 = texture2D(heightMap, hcoord1).x;

  vec2 hcoord2 = vec2(height1) * heightOffset + vec2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
  hcoord2.y = 1.0 - hcoord2.y;
  float height2 = texture2D(heightMap, hcoord2).x;

  vec2 hcoord3 = vec2(height2) * heightOffset + vec2(in_Coordinate0.x, 1.0 - in_Coordinate0.y);
  hcoord3.y = 1.0 - hcoord3.y;
  vec3 mainColor = texture2D(diffuseMap, hcoord3).xyz;
  mainColor *= mainColor;

  vec3 light = lightColor * Light1Intensity * ShadowMask + ambientColor;
  vec3 finalColor = mainColor + vec3(totalSpecular);
  finalColor *= light;

  vec4 out_Color = vec4(finalColor, 1.0);

#END_CODE
#END_DEFINE

// 指定片元位置
#SHADER_DEFINE VertexOutput
    FUNCTION_INPUT =
    {
        { SCREENSPACE_POSITION,        HIGH,    VEC4,    "in_ScreenPosition" },
    }
    FUNCTION_OUTPUT = { }
#SHADER_CODE
    gl_Position = in_ScreenPosition;
#END_CODE
#END_DEFINE

//输出到片元
#SHADER_DEFINE FragmentOutput

    FUNCTION_INPUT =
    {
      { SURFACE_COLOR,                  MEDIUM,   VEC4,         "color"},
    }
    FUNCTION_OUTPUT = { }

#SHADER_CODE
		gl_FragColor = color;

#END_CODE
#END_DEFINE
