

#SHADER_DEFINE SliceConstIn

	FUNCTION_INPUT = 
	{
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE	
    float slice_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceConstOut

	FUNCTION_INPUT =
	{
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
    float slice_out_EasingV = 0.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceLinearIn

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
    float slice_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceLinearOut

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
    float slice_out_EasingV = in_Progress;
#END_CODE
#END_DEFINE


#SHADER_DEFINE SliceSineIn

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
    float slice_out_EasingV = sin((in_Progress - 1.0) * 1.5707963267948966) + 1.0;
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceSineOut

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
    float slice_out_EasingV = sin(in_Progress * 1.5707963267948966);
#END_CODE
#END_DEFINE


#SHADER_DEFINE SliceExponentialIn

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE

  float slice_out_EasingV = 0.0;
  if (in_Progress == 0.0)
    slice_out_EasingV = in_Progress;
  else
    slice_out_EasingV = pow(2.0,10.0 * (in_Progress - 1.0));
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceExponentialOut

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
  float slice_out_EasingV = 0.0;
  if (in_Progress == 1.0)
    slice_out_EasingV = in_Progress;
  else
    slice_out_EasingV = 1.0 - pow(2.0, -10.0 * in_Progress);
#END_CODE
#END_DEFINE


#SHADER_DEFINE SliceBackIn

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
  float slice_out_EasingV = pow(in_Progress,3.0) - in_Progress * sin(in_Progress * 3.141592653589793);
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceBackOut

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
  float f_slicebackout = 1.0 - in_Progress;
  float slice_out_EasingV = 1.0 - (pow(f_slicebackout, 3.0) - f_slicebackout * sin(f_slicebackout * 3.141592653589793));
#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceBounceOut

	FUNCTION_INPUT =
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE
  const float a_slicebout = 4.0 / 11.0;
  const float b_slicebout = 8.0 / 11.0;
  const float c_slicebout = 9.0 / 10.0;

  const float ca_slicebout = 4356.0 / 361.0;
  const float cb_slicebout = 35442.0 / 1805.0;
  const float cc_slicebout = 16061.0 / 1805.0;

  float t2_slicebout = in_Progress * in_Progress;

  float slice_out_EasingV = 0.0;
  if (in_Progress < a_slicebout)
  {
    slice_out_EasingV = 7.5625 * t2_slicebout;
  }
  else
  {
    if (in_Progress < b_slicebout)
    {
      slice_out_EasingV = 9.075 * t2_slicebout - 9.9 * in_Progress + 3.4;
    }
    else
    {
      if (in_Progress < c_slicebout)
      {
        slice_out_EasingV = ca_slicebout * t2_slicebout - cb_slicebout * in_Progress + cc_slicebout;
      }
      else
      {
        slice_out_EasingV = 10.8 * in_Progress * in_Progress - 20.52 * in_Progress + 10.72;
      }
    }
  }

#END_CODE
#END_DEFINE

#SHADER_DEFINE SliceBounceIn

	FUNCTION_INPUT = 
	{
		{ EASING_PROGRESS, 		MEDIUM,	FLOAT,	"in_Progress" },
	}
	FUNCTION_OUTPUT =
	{
    { SLICE_EASING_VALUE,           MEDIUM, FLOAT,  "slice_out_EasingV"},
	}

#SHADER_CODE	

  float t_slicebin = 1.0 - in_Progress;
  const float a_slicebin = 4.0 / 11.0;
  const float b_slicebin = 8.0 / 11.0;
  const float c_slicebin = 9.0 / 10.0;

  const float ca_slicebin = 4356.0 / 361.0;
  const float cb_slicebin = 35442.0 / 1805.0;
  const float cc_slicebin = 16061.0 / 1805.0;

  float t2_slicebin = t_slicebin * t_slicebin;
  
  float slice_out_EasingV = 0.0;
  if (t_slicebin < a_slicebin)
  {
    slice_out_EasingV = 7.5625 * t2_slicebin;
  }
  else
  {
    if (t_slicebin < b_slicebin)
    {
      slice_out_EasingV = 9.075 * t2_slicebin - 9.9 * t_slicebin + 3.4;
    }
    else
    {
      if (t_slicebin < c_slicebin)
      {
        slice_out_EasingV = ca_slicebin * t2_slicebin - cb_slicebin * t_slicebin + cc_slicebin;
      }
      else
      {
        slice_out_EasingV = 10.8 * t_slicebin * t_slicebin - 20.52 * t_slicebin + 10.72;
      }
    }
  }
  slice_out_EasingV = 1.0 - slice_out_EasingV;

#END_CODE
#END_DEFINE



