
#DEFPARAMS
UNIFORM_INPUT_TEXTURE         = {"UNIFORM_INPUT_TEXTURE",         TEXTURE2D, "UNIFORM_INPUT_TEXTURE"},
UNIFORM_BLUR_TEXTURE          = {"UNIFORM_BLUR_TEXTURE",          TEXTURE2D, "UNIFORM_BLUR_TEXTURE"},
UNIFORM_BLUR_TEXTURE2         = {"UNIFORM_BLUR_TEXTURE2",         TEXTURE2D, "UNIFORM_BLUR_TEXTURE2"},
UNIFORM_MASK_TEXTURE          = {"UNIFORM_MASK_TEXTURE",          TEXTURE2D, "UNIFORM_MASK_TEXTURE"},
UNIFORM_EYE_MASK_TEXTURE      = {"UNIFORM_EYE_MASK_TEXTURE",      TEXTURE2D, "UNIFORM_EYE_MASK_TEXTURE"},
UNIFORM_TEETH_LOOKUP_TEXTURE  = {"UNIFORM_TEETH_LOOKUP_TEXTURE",  TEXTURE2D, "UNIFORM_TEETH_LOOKUP_TEXTURE"},
UNIFORM_BRIGHT_EYE_STRENGTH   = {"UNIFORM_BRIGHT_EYE_STRENGTH",   FLOAT, "0.0"},
UNIFORM_NAOLABIAL_STRENGTH    = {"UNIFORM_NAOLABIAL_STRENGTH",    FLOAT, "0.0"},
UNIFORM_EYEBAG_STRENGTH       = {"UNIFORM_EYEBAG_STRENGTH",       FLOAT, "0.0"},
UNIFORM_WHITEN_TEETH_STRENGTH = {"UNIFORM_WHITEN_TEETH_STRENGTH", FLOAT, "0.0"},
#END

#DEFTAG
ShaderName  = "face_beauty"
RenderQueue = "Transparent"
#END

#DEFPASS Always
COLOR_MASK   = COLOR_RGBA
ALPAH_MODE   = { ALPAH_OFF }
DRAW_MODE    = { CULL_FACE_OFF, DEPTH_MASK_OFF, DEPTH_TEST_OFF, DEPTH_FUNCTION_LESS }
STENCIL_MODE = {STENCIL_OFF}

CGPROGRAM
#pragma vertex vert
#pragma fragment frag
#include "common.inc"

struct appdata
{
    float3 in_pos : POSITION;
    float2 in_tex_coord : TEXCOORD0;
};

struct v2f
{
    float2 out_tex_coord : TEXCOORD0;
    float2 out_mask_coord : TEXCOORD1;
    float4 out_pos : SV_POSITION;
    float2 out_visibility : TEXCOORD2;
};

v2f vert(appdata v)
{
    v2f o;
    o.out_tex_coord           = float2(0.5 * (v.in_pos.x + 1), 1 - 0.5 * (v.in_pos.y + 1));
    o.out_mask_coord          = v.in_tex_coord;
    o.out_pos                 = UniformNDC(float4(v.in_pos.x, v.in_pos.y, 0.0, 1.0));
    o.out_visibility          = float2(v.in_pos.z, 0.0);
    return o;
}

Texture2D UNIFORM_INPUT_TEXTURE;
Texture2D UNIFORM_BLUR_TEXTURE;
Texture2D UNIFORM_BLUR_TEXTURE2;
Texture2D UNIFORM_MASK_TEXTURE;
Texture2D UNIFORM_EYE_MASK_TEXTURE;
Texture2D UNIFORM_TEETH_LOOKUP_TEXTURE;
SamplerState UNIFORM_INPUT_Sampler;
SamplerState UNIFORM_BLUR_Sampler;
SamplerState UNIFORM_BLUR_Sampler2;
SamplerState UNIFORM_MASK_Sampler;
SamplerState UNIFORM_EYE_MASK_Sampler;
SamplerState UNIFORM_TEETH_LOOKUP_Sampler;

float UNIFORM_BRIGHT_EYE_STRENGTH;
float UNIFORM_NAOLABIAL_STRENGTH;
float UNIFORM_EYEBAG_STRENGTH;
float UNIFORM_WHITEN_TEETH_STRENGTH;

void frag(in v2f i, out float4 mainColor : SV_Target0)
{
#define input_texture UNIFORM_INPUT_TEXTURE
#define blur_texture UNIFORM_BLUR_TEXTURE
#define blur_texture2 UNIFORM_BLUR_TEXTURE2
#define mask_texture UNIFORM_MASK_TEXTURE
#define eye_mask_texture UNIFORM_EYE_MASK_TEXTURE
#define teeth_lookup_texture UNIFORM_TEETH_LOOKUP_TEXTURE
#define bright_eye_strength UNIFORM_BRIGHT_EYE_STRENGTH
#define nasolabial_strength UNIFORM_NAOLABIAL_STRENGTH
#define eyebag_strength UNIFORM_EYEBAG_STRENGTH
#define whiten_teeth_strength UNIFORM_WHITEN_TEETH_STRENGTH

    float2 frag_tex_input_coord = i.out_tex_coord;
    float2 frag_tex_coord       = i.out_tex_coord;
    float2 frag_mask_coord      = i.out_mask_coord;

    float4 sourceColor = UNIFORM_INPUT_TEXTURE.Sample(UNIFORM_INPUT_Sampler, frag_tex_input_coord);
    float3 resultColor = sourceColor.xyz;

    float4 maskColor    = UNIFORM_MASK_TEXTURE.Sample(UNIFORM_MASK_Sampler, frag_mask_coord);

    if (maskColor.x > 0.01 && maskColor.z < 0.01 && bright_eye_strength >= 0.01) // 亮眼
    {
        float2 step1 = float2(0.004000301, 0.0);
        float2 step2 = float2(0.0, 0.004000301);
        float3 sumColor = float3(0.0, 0.0, 0.0);
        for(float t = -2.0; t < 2.5; t += 1.0)
        {
            for(float p = -2.0;p < 2.5; p += 1.0)
            {
                sumColor += UNIFORM_INPUT_TEXTURE.Sample(UNIFORM_INPUT_Sampler, frag_tex_input_coord + t * step1 + p * step2).xyz;
            }
        }
        sumColor = sumColor * 0.04;
        sumColor = clamp(sumColor + (sourceColor.xyz - sumColor) * 3.0, 0.0, 1.0);
        sumColor = max(sourceColor.xyz, sumColor);

        float Fbright_eye_strength = bright_eye_strength * i.out_visibility.x;

        resultColor = lerp(sourceColor.xyz, sumColor, Fbright_eye_strength * 0.5 * maskColor.x);

        float4 eyeMaskColor = UNIFORM_EYE_MASK_TEXTURE.Sample(UNIFORM_EYE_MASK_Sampler, frag_mask_coord);

        float3 grayColor = resultColor;
        float3 brightColor = clamp(grayColor * grayColor * -0.3543 + 1.354 * grayColor, 0.0, 1.0);
        resultColor = lerp(grayColor, brightColor, eyeMaskColor.g * Fbright_eye_strength * 0.5);

        float3 shadowColor = clamp(grayColor * grayColor * 0.3401 + 0.6599 * grayColor, 0.0, 1.0);
        resultColor = lerp(resultColor, shadowColor, eyeMaskColor.b * Fbright_eye_strength * 0.5);
    }
    else if (maskColor.y > 0.01 && eyebag_strength >= 0.01) // 祛黑眼圈
    {
        float3 blurColor1 = UNIFORM_BLUR_TEXTURE.Sample(UNIFORM_BLUR_Sampler, frag_tex_coord).xyz;
        float3 blurColor2 = UNIFORM_BLUR_TEXTURE2.Sample(UNIFORM_BLUR_Sampler2, frag_tex_coord).xyz;
        // 放大差值，用输入的图像加上差值，消除差值所带来的影响
        float3 diffColor = clamp((blurColor2 - blurColor1) * 1.3 + 0.03 * blurColor2, 0.0, 0.2);

        resultColor = lerp(sourceColor.xyz, min(sourceColor.xyz + diffColor, 1.0), eyebag_strength * maskColor.y);
    }
    else if (maskColor.z > 0.01 && maskColor.x < 0.01 && nasolabial_strength >= 0.01) // 祛法令纹
    {
        float3 blurColor1 = UNIFORM_BLUR_TEXTURE.Sample(UNIFORM_BLUR_Sampler, frag_tex_coord).xyz;
        float3 blurColor2 = UNIFORM_BLUR_TEXTURE2.Sample(UNIFORM_BLUR_Sampler2, frag_tex_coord).xyz;
        // 放大差值，用输入的图像加上差值，消除差值所带来的影响
        float3 diffColor = clamp((blurColor2 - blurColor1) * 1.4 + 0.05 * blurColor2, 0.0, 0.3);

        resultColor = lerp(sourceColor.xyz, min(sourceColor.xyz + diffColor, 1.0), nasolabial_strength * maskColor.z);
    }
    else if (maskColor.z > 0.01 && maskColor.x > 0.01 && whiten_teeth_strength >= 0.01) // 白牙
    {
        //min16float blueColor = sourceColor.z * 15.0;
        float blueColor = sourceColor.z * 15.0;

        float2 quad1;
        float2 quad2;

        quad1.y = floor(floor(blueColor) * 0.25);
        quad1.x = floor(blueColor) - (quad1.y * 4.0);

        quad2.y = floor(ceil(blueColor) * 0.25);
        quad2.x = ceil(blueColor) - (quad2.y * 4.0);

        float2 texPos1;
        float2 texPos2;

        texPos1.x = (quad1.x * 0.25) + 0.0078125 + (0.234375 * sourceColor.x);
        texPos1.y = (quad1.y * 0.25) + 0.0078125 + (0.234375 * sourceColor.y);

        texPos2.x = (quad2.x * 0.25) + 0.0078125 + (0.234375 * sourceColor.x);
        texPos2.y = (quad2.y * 0.25) + 0.0078125 + (0.234375 * sourceColor.y);

        //min10float float3 newColor1 = Sample(teeth_lookup_texture, texPos1).xyz;
        //min10float float3 newColor2 = Sample(teeth_lookup_texture, texPos2).xyz;
        //min10float float3 newColor = lerp(newColor1, newColor2, fract(blueColor));
        float3 newColor1 = UNIFORM_TEETH_LOOKUP_TEXTURE.Sample(UNIFORM_TEETH_LOOKUP_Sampler, texPos1).xyz;
        float3 newColor2 = UNIFORM_TEETH_LOOKUP_TEXTURE.Sample(UNIFORM_TEETH_LOOKUP_Sampler, texPos2).xyz;
        float3 newColor = lerp(newColor1, newColor2, frac(blueColor));

        resultColor = lerp(sourceColor.xyz, newColor, whiten_teeth_strength * maskColor.z);
    }
    
    mainColor = float4(resultColor, sourceColor.w);
}

ENDCG
#END