local basetype = require "venuscore.rtti.types.basetype"


local ReferenceArrayType = basetype:extend("ReferenceArray");--这个名字不能改，影响序列化


function ReferenceArrayType:new(reference_type, get, set,getByIndex, setByIndex)
  ReferenceArrayType.super.new(self, get, set);
  self.getByIndex = getByIndex;
  self.setByIndex = setByIndex;
  self.reference_type = reference_type;  
end

function ReferenceArrayType:SetKeyname(keyname)
  if not self.getByIndex then
    self.getByIndex = function(currentobj,index)
      return currentobj[keyname][index];
    end    
  end  
  if not self.setByIndex then
    self.setByIndex = function(currentobj, index,value)
      currentobj[keyname][index] = value;
    end    
  end  
  ReferenceArrayType.super.SetKeyname(self,keyname);
end


function ReferenceArrayType:GetReferenceType()
  return self.reference_type;
end

function ReferenceArrayType:isMemberTypeReference()
  return true;
end

function ReferenceArrayType:isTypeOrDriverType(other)
  return self.reference_type:isTypeOrDriverType(other)
end

function ReferenceArrayType:isType(other)
  return self.reference_type:GetTypeID() == other:GetTypeID()
end

function ReferenceArrayType:GetArrayItem(obj,index)
  return self.getByIndex(obj,index);
end

function ReferenceArrayType:SetArrayItem(obj,index,value)
  self.setByIndex(obj,index,value)
end



return ReferenceArrayType;