local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"

local stretchdistortion = {}
stretchdistortion.material = nil;
stretchdistortion.renderobject = nil;
stretchdistortion.Queue = 120;

function stretchdistortion:Initialize(host, size)
    --<!--  set the offsets parameters in vertex shader -->
  self.renderobject = host:CreateRenderObject();
  self.material = host:CreateMaterial("comm:documents/filter/material/stretchdistortion.material" );
  return self.Queue;
end

function stretchdistortion:Resizeview(size)
   --self:_SetParam(size);
end

function stretchdistortion:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.material:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.renderobject, self.material);
  context:EndRenderPass();
end

return stretchdistortion;