local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local venuscore = require "venuscore"

local addblendfilter = {}
addblendfilter.AbfMat = 0;
addblendfilter.Queue = 115;

local imagePath = "comm:documents/material/background.jpg";
function addblendfilter:Initialize(host, size)
  self.tex = apolloengine.TextureEntity();
  self.tex:PushMetadata(apolloengine.TextureFileMetadata(
	  apolloengine.TextureEntity.TU_STATIC,
      apolloengine.TextureEntity.PF_AUTO,1, false,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TW_CLAMP_TO_BORDER,
      apolloengine.TextureEntity.TF_LINEAR,
      apolloengine.TextureEntity.TF_LINEAR,
      imagePath));
  self.tex:SetJobType(venuscore.IJob.JT_SYNCHRONOUS);
  self.tex:CreateResource();
    --<!--  set the offsets parameters in vertex shader -->
  self.MIX_TEXTURE =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"MIX_TEXTURE");
  self.AlPHA =apolloengine.IMaterialSystem:NewParameterSlot(
    apolloengine.ShaderEntity.UNIFORM,"AlPHA");
  self.AbfMat = host:CreateMaterial("comm:documents/filter/material/addblendfilter.material");
  self.AbfRO = host:CreateRenderObject()
  self.AbfMat:SetParameter(self.MIX_TEXTURE, self.tex);
  self.AbfMat:SetParameter(self.AlPHA, mathfunction.vector1(0.4));
  --self:_SetParam(size);
  return self.Queue;
end

function addblendfilter:Resizeview(size)
  --self:_SetParam(size);
end

function addblendfilter:Process(context, Original, Scene, Output)
  context:BeginRenderPass(Output, apolloengine.RenderTargetEntity.CF_COLOR);
  self.AbfMat:SetParameter(
		apolloengine.ShaderEntity.TEXTURE_DIFFUSE,
		Scene:GetAttachment( apolloengine.RenderTargetEntity.TA_COLOR_0 ) );
  context:Draw(self.AbfRO, self.AbfMat);
  context:EndRenderPass();
end

return addblendfilter;
