local venuscore = require "venuscore"

local BlueDebug = {};
BlueDebug.isDebugYield = false
BlueDebug.isAllowYield = true; --是否允许断点生效

function BlueDebug:Update(scene, def)
  g_callbackhandle:AsyncInvoker(
    function()
      if not self.isDebugYield then
        --和facecute保持一致
        def = def < 0.1 and def or 0.03;
        scene:Update(def)
      end
    end);
end
 
function BlueDebug:DebugYield()
  if not self.isAllowYield then
    return;
  end
  if not self.isDebugYield then
    self.isDebugYield = true;
    self.context = venuscore.Context:GetServiceContext();
    g_callbackhandle:AsyncEnd();--同时通知结束等大
    self.context:Pasue();
  else
    error("debugging");
  end
end

function BlueDebug:DebugContinue()
  if self.isDebugYield then
    self.isDebugYield = false;
    self.context:Resume();
    g_callbackhandle:AsyncBegin();--同时通知等待调用完成
  else
    error("running");
  end  
end

function BlueDebug:DebugReset() --运行蓝图遇到断点yield住的时候按下Stop调用
  if self.isDebugYield then
    self:DebugContinue()
  end
end

function BlueDebug:SetAllowYield(isAllow)
  self.isAllowYield = isAllow;
end

function BlueDebug:GetAllowYield()
  return  self.isAllowYield;
end

function BlueDebug:isYield()
  return self.isDebugYield;
end

return BlueDebug;