local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local RandomIntRange = BlueNode:extend();

---- 游戏运行模式
function RandomIntRange:new(...)
  RandomIntRange.super.new(self, ...)
end

function RandomIntRange:_OnUpdate(args)
  return math.random(args[1], args[2])
end

---- 编辑器模式
RandomIntRange:RegisterInput(1, Types.IntType, "min", "最小(含)", 1)
RandomIntRange:RegisterInput(2, Types.IntType, "max", "最大(含)", 2)
RandomIntRange:RegisterOutput(1, Types.IntType, "Random Int", "返回指定范围的随机数")

RandomIntRange:SetFunctionName("Random Int With Range")
RandomIntRange:SetFunctionType(BD.STATIC_FUNCTION_NODE)

return RandomIntRange;