local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local Sqrt = BlueNode:extend();

function Sqrt:new(...)
  Sqrt.super.new(self, ...)
end

function Sqrt:_OnUpdate(args)
  return math.sqrt(math.abs(args[1]));
end

Sqrt:RegisterInput(1, Types.FloatType, "in", "输入", 0);
Sqrt:RegisterOutput(1, Types.FloatType, "sqrt", "开平方(输入会先取绝对值)");

Sqrt:SetFunctionName("sqrt");
Sqrt:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return Sqrt;

