local mf = require "mathfunction"
local BD = require "bluecore.bluedefined"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BreakVector2f = BlueNode:extend();

---- 游戏运行模式
function BreakVector2f:new(...)
  BreakVector2f.super.new(self, ...)
end

function BreakVector2f:_OnUpdate(args)
  local vec2f = args[1] ;
  return vec2f:x(), vec2f:y();
end


---- 编辑器模式
BreakVector2f:RegisterInput(1, mf.vector2():RTTI(), "Vector2f Break", "拆分向量(x,y)", mf.vector2(0.0,0.0));
BreakVector2f:RegisterOutput(1, Types.FloatType, "x", "x 浮点");
BreakVector2f:RegisterOutput(2, Types.FloatType, "y", "y 浮点");


BreakVector2f:SetFunctionName("Break Vector2f");
BreakVector2f:SetFunctionType(BD.STATIC_FUNCTION_NODE);

return BreakVector2f ;