local AE = require "apollocore"
local Types = require "venuscore.rtti.types"
local Base = require "bluecore.base.overlay_base_regex"
local BD = require "bluecore.bluedefined"
local BU = require "bluecore.blueutility"
local KeepOverlayRegex = Base:extend();

function KeepOverlayRegex:new(...)
  KeepOverlayRegex.super.new(self, ...)
end

function KeepOverlayRegex:_OnUpdate(eventParam)

  local otherComp = eventParam.otherComp ;
  local otherNode = eventParam.otherNode ;
  local otherName = eventParam.otherName ;
  local collisionPointInfo = eventParam.collisionPointInfo ;

  local found = string.find(otherName, self.regexString)

  if found == nil then
    self.nextExecIdx = Base.BREAK
    return
  end

  self.nextExecIdx = Base.TRIGGER
  return otherNode, otherComp, collisionPointInfo;
end


function KeepOverlayRegex:_GetType()
  return BD.Event.CollisionEvent.KeepOverlay
end

KeepOverlayRegex:RegisterOutput(1, AE.Node:RTTI(), "node" , "other node")
KeepOverlayRegex:RegisterOutput(2, AE.RigidBodyComponent:RTTI(), "comp", "other component")
KeepOverlayRegex:RegisterOutput(3, BU:GetArrayRtti(Types.CollisionDataType) , "data", "碰撞点和法线");
KeepOverlayRegex:SetFunctionName("Keep Overlay");

return KeepOverlayRegex;