local venuscore = require "libvenuscore"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"
local BlueSelf = require "bluecore.blueself"
local EventDispatcher = require "bluecore.eventdispatcher"
local BD = require "bluecore.bluedefined"
local CV = require "computervisionfunction"
local BU = require "bluecore.blueutility"
local RecognitionFace134 = BlueNode:extend();

---- 游戏运行模式
function RecognitionFace134:new(...)
  RecognitionFace134.super.new(self, ...)
  self._formatOutputArray = {}
end

function RecognitionFace134:_OnUpdate(args)
  self._formatOutputArray = args
  return self._formatOutputArray;
end

function RecognitionFace134:_OnNextBranch()
  if self._formatOutputArray ~= nil and next(self._formatOutputArray) then
    return 1
  else
    return 0
  end
end

function RecognitionFace134:RegisterTriggerFunc(func, bluePrintSelf)
  self:_GetInput()

  local comp = self.component or self.inputArgs[1]

  EventDispatcher:RegisterCallback(
          comp:GetContentPath(),
          CV.RecognitionComponent.cvAdvancedLandmark,
          func,
          bluePrintSelf)
end

function RecognitionFace134:_OnCompile()
  self.compileResult = nil
  if RecognitionFace134.super._OnCompile(self) then


    local comp = self.component

    -- Step.0 判断反射面板有override
    if comp ~= nil then
      if venuscore.isNil(comp) then
        self.compileResult = BD.EHINT.COMP_LOST
        return false
      end
    end

    if comp == nil then

    -- Step.1 确保Component引脚有连接
      if #self.inputs[1].links ~= 0 then
        local bluePinLink = self.inputs[1].links[1] -- 输入引脚只允许一个连接
        local otherNode = self.graph:GetNode(bluePinLink.nodeUid);

        -- Step.2 确保上一个节点是 引用组件类型 的节点
        if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp == nil then
          self.compileResult = BD.EHINT.NOT_LINK_TO_COMP
          return false
        end

        if venuscore.isNil(otherNode.comp) then
          self.compileResult = BD.EHINT.COMP_LOST
          return false
        end

        comp = otherNode.comp

      else
        self.compileResult = BD.EHINT.PIN_1_EMPTY;
        return false
      end

    end

    -- Step.3 RecognitionComponent没有激活当前的检测类型
    local hasType = self:_HasType(comp);
    if not hasType then
      self.compileResult = BD.EHINT.NOT_ENABLE;
    end

    return true ;
  end
  return false;
end

function RecognitionFace134:_HasType(comp)
  return bit.band(comp.Type, CV.RecognitionComponent.cvAdvancedLandmark) ~= 0
end

function RecognitionFace134:_OnDeserialize()

end

-- 蓝图节点反射面板相关
function RecognitionFace134:_SetComp(comp)
  self.component = comp ;
end

function RecognitionFace134:_GetComp()
  return self.component
end

function RecognitionFace134:ReflectFilterFtnOnPrefab(obj, member, value)
  return member == "component"
end

function RecognitionFace134:LiteralMismatchOnCompile(pin, pinInfo)
  if pin.argId ==  1 and BU:isBlueSelf(pin.literal) and  not venuscore.isNil(self.component) then
    return true
  end
  return false
end

RecognitionFace134:MemberRegister("component",
        Types.ReferenceType(CV.RecognitionComponent:RTTI(),
                RecognitionFace134._GetComp, RecognitionFace134._SetComp));


---- 编辑器模式
if _KRATOSEDITOR then

function RecognitionFace134:_OnLink(selfPin, otherNode, otherPin)
  if BU:IsInputPin(selfPin) and selfPin.argId == 1 then
    if otherNode:GetFunctionType() == BD.COMPONENT_NODE and otherNode.comp then
      if venuscore.isNil(otherNode.comp) then
        ERROR(BD.EHINT.COMP_LOST)
      else
        local hasType = self:_HasType(otherNode.comp);
        if not hasType then
          ERROR(BD.EHINT.NOT_ENABLE)
        end
      end
    else
      ERROR(BD.EHINT.NOT_LINK_TO_COMP)
    end
  end
end

function RecognitionFace134:_OnUnLink(unlinkPin)
  if unlinkPin.argId == 1 then -- 断开是第一个引脚
     ERROR(BD.EHINT.PIN_1_EMPTY)
  end
end


function RecognitionFace134:_OnCreateWithEditor()
  RecognitionFace134.super._OnCreateWithEditor(self);
end

function RecognitionFace134:_OnUpdateByEditor()

  RecognitionFace134.super._OnUpdateByEditor(self);

  -- 如果编辑器显示当前蓝图,即时显示检查结果
  self:_OnCompile();
end

end

RecognitionFace134:RegisterInput(1, CV.RecognitionComponent:RTTI(), "component", "监听组件", BlueSelf());

RecognitionFace134:RegisterOutput(1, BU:GetArrayRtti(Types.Advance134Type), "result", "检测结果");

RecognitionFace134:RegisterExecOutput(1, "OnTrigger", "执行");

RecognitionFace134:SetFunctionName("Advance 134");

RecognitionFace134:SetFunctionType(BD.EVENT_FUNCTION_NODE);

RecognitionFace134:SetEventType(BD.EventType.RegisterCallback);

return RecognitionFace134;

