local BD = require "bluecore.bluedefined"
local BATNode = require "bluecore.base.blue_anytype_node"
local Types = require "venuscore.rtti.types"

local DeleteArrayElementByIndex = BATNode:extend();

---- 游戏运行模式
function DeleteArrayElementByIndex:new(...)
  DeleteArrayElementByIndex.super.new(self, ...)
end

function DeleteArrayElementByIndex:_OnUpdate(args)
  local array = args[1]
  local index = args[2]

  if array == nil then
    ERROR("[DeleteArrayElementByIndex] array is nil")
    return nil ;
  end
  if index <= 0 or index > #array then
    ERROR("[DeleteArrayElementByIndex] index "..tostring(index).." is illegal ".."legal range is [1,"..tostring(#array).."]");
    return array ;
  end
  table.remove(array, index);
  return array;
end

---- 编辑器模式
DeleteArrayElementByIndex:RegisterExecInput(1, "Exec", "执行");
DeleteArrayElementByIndex:RegisterExecOutput(1, "Exec", "执行");

DeleteArrayElementByIndex:RegisterInput(1, Types.AnyArrayType, "Array", "通配数组", Types.AnyArrayType(), false, BATNode.DEFAULT_GROUP);
DeleteArrayElementByIndex:RegisterInput(2, Types.IntType, "Index", "数组索引(从1开始)", 1, false, nil)
DeleteArrayElementByIndex:RegisterOutput(1, Types.AnyArrayType, "result", "输出数组", Types.AnyArrayType(), false , BATNode.DEFAULT_GROUP);

DeleteArrayElementByIndex:SetFunctionName("Delete Array Element");

return DeleteArrayElementByIndex ;