local apolloengine = require "apolloengine"

local BlueSelf = require "bluecore.blueself"
local BlueNode = require "bluecore.bluenode"
local Types = require "venuscore.rtti.types"

local ReplayAllAni = BlueNode:extend();

---- 游戏运行模式
function ReplayAllAni:new(...)
  ReplayAllAni.super.new(self,...);
end


function ReplayAllAni:_OnUpdate(args)
  self:_RecursiveResetNode(args[1]);
end


function ReplayAllAni:_RecursiveResetNode(rootNode)

  local AniCom = rootNode:GetComponent(apolloengine.Node.CT_ANIMATION);
  if AniCom then
    AniCom:Reset();
    AniCom:Play();
  end
  local childNode = rootNode:GetChildrens();
  for i=1,#childNode do
    local node = childNode[i];
    self:_RecursiveResetNode(node);
  end
end


---- 编辑器模式
ReplayAllAni:RegisterInput(1, apolloengine.Node:RTTI(), "target", "递归遍历子节点，重新播放所有动画组件", BlueSelf());

ReplayAllAni:RegisterExecInput(1, "exec", "Execute");

ReplayAllAni:RegisterExecOutput(1, "exec", "Execute");

ReplayAllAni:SetFunctionName("ReplayAllAni");

return ReplayAllAni ;

