local AE = require "apolloengine"
local MF = require "mathfunction"
local Types = require "venuscore.rtti.types"

local BlueNode = require "bluecore.bluenode"
local BlueSelf = require "bluecore.blueself"

local MoveToPosition = BlueNode:extend();

local current_time = 0.0;
local moving_time = 0.0;
local total_time;

function MoveToPosition:new(...)
  MoveToPosition.super.new(self,...)
end

function MoveToPosition:_OnUpdate(args)
  local target_pos = args[1];
  local follow_comp = args[2];
  local total_time = args[3];
  local moving_time = args[4];

  -- 设置 follow pos
  local lastPosition = follow_comp:GetWorldPosition();
  local dirPosition = target_pos - lastPosition;
  local deltaPosition = dirPosition / total_time * moving_time;
  follow_comp:SetWorldPosition(deltaPosition + lastPosition);

end

MoveToPosition:RegisterInput(1, MF.vector3:RTTI(), "vec3", "向量");
MoveToPosition:RegisterInput(2, AE.TransformComponent:RTTI(), "follow", "node", BlueSelf());
MoveToPosition:RegisterInput(3, Types.FloatType, "totalTime", "移动总时长", 0.0);
MoveToPosition:RegisterInput(4, Types.FloatType, "movingTime", "已经移动的时长", 0.0);

MoveToPosition:RegisterExecInput(1, "exec", "执行");
MoveToPosition:RegisterExecOutput(1, "exec", "执行");
MoveToPosition:SetFunctionName("Move To Position");

return MoveToPosition;
