local apolloengine = require "apolloengine"
local mathfunction = require "mathfunction"
local BD = require "bluecore.bluedefined"
local Types = require "venuscore.rtti.types"
local SetPostEffectValue = require "bluecore.base.set_posteffect_value"
local SetPostEffectVector4 = SetPostEffectValue:extend();


---- 游戏运行模式
function SetPostEffectVector4:new(...)
  SetPostEffectVector4.super.new(self, ...)

end




function SetPostEffectVector4:_IsRightType(value)
  return type(value) == "userdata" and value:RTTI() == mathfunction.vector4:RTTI();
end



SetPostEffectVector4:RegisterInput(1, Types.CameraPostEffectRefType, "postEffect", "后处理", Types.NotNullType());
SetPostEffectVector4:RegisterInput(2, Types.ComboType, "ParaName", "参数名字", BD.EMPTY_STRING); --instance可选的vector3变量
SetPostEffectVector4:RegisterInput(3, mathfunction.vector4:RTTI(), "ParaValue", "参数值", mathfunction.vector4(1.0,1.0,1.0,1.0));


SetPostEffectVector4:RegisterExecInput(1, "exec", "执行");

SetPostEffectVector4:RegisterExecOutput(1, "exec", "执行");

SetPostEffectVector4:SetFunctionName("SetPostEffectVector4");


return SetPostEffectVector4 ;

